local module_args = ...
assert(module_args.form_name and module_args.label and module_args.yes_handler)

local module_ret = {}

local S = superquest.S

local players_data = {}

local formspec_data = "formspec_version[4]" ..
    "size[12,2.2]" ..
    "label[0.5,0.5;"..module_args.label.."]" ..
    "button_exit[0.5,1;5.2,0.8;yes;"..S("Yes").."]" ..
    "button_exit[6.3,1;5.2,0.8;no;"..S("No").."]"

module_ret.show = function(player_name, data)
    players_data[player_name] = data
    core.show_formspec(player_name, module_args.form_name, formspec_data)
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= module_args.form_name then
        return false
    end

    if not (player and player:is_player()) then
        return true
    end

    local player_name = player:get_player_name()

    if not players_data[player_name] then
        return true
    end

    if fields.yes then
        module_args.yes_handler(player, players_data[player_name])
    else
        if module_args.no_handler then
            module_args.no_handler(player)
        end
    end

    players_data[player:get_player_name()] = nil

    return true
end)

core.register_on_leaveplayer(function(player)
    players_data[player:get_player_name()] = nil
end)

return module_ret
