local module_args = ...

assert(module_args.get_quest_machine_coords and module_args.is_owner_mode_for_player
   and module_args.show_formspec_handler and module_args.remove_quest_machine_data_handler
   and module_args.try_to_receive_reward_handler)

local module_ret = {}

local S = superquest.S

local can_dig = function(pos, player)
    local meta = core.get_meta(pos)
    local inv = meta:get_inventory()

    local res = inv:is_empty("reward_box_storage")
    if (not res and player and player:is_player()) then
        core.chat_send_player(player:get_player_name(), S("The reward inventory is not empty!"))
    end

    return res

    -- We don't need to check if the player is owner because quest machines should be placed in protected areas anyway
end

local after_place_node = function(pos, placer, itemstack)
    local meta = core.get_meta(pos)
    if placer and placer:is_player() then
        meta:set_string("owner", placer:get_player_name())
    end

    local inv = meta:get_inventory()

    inv:set_size("first_compl_rewards", 8)
    inv:set_size("further_compl_rewards", 8)
    inv:set_size("reward_box_storage", 32)
end

local on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
    if not (clicker and clicker:is_player()) then
        return
    end

    local clicker_name = clicker:get_player_name()

    module_args.show_formspec_handler(pos, clicker_name)
end

local on_destruct = module_args.remove_quest_machine_data_handler

local facedir_to_front_dir_table = {
    [0] = 2, 4, 1, 3, 0, 4, 5, 3, 5, 4, 0, 3, 2, 0, 1, 5, 2, 5, 1, 0, 2, 3, 1, 4
}

local front_dir_vector = {
    [0] = vector.new(0, 1, 0),
    [1] = vector.new(0, 0, 1),
    [2] = vector.new(0, 0, -1),
    [3] = vector.new(1, 0, 0),
    [4] = vector.new(-1, 0, 0),
    [5] = vector.new(0, -1, 0),
}

local function facedir_to_front_dir_vector(facedir)
    return front_dir_vector[facedir_to_front_dir_table[facedir]]
end

local function show_particles(pos, node)
    local particles_speed = facedir_to_front_dir_vector(node.param2)
    local pos_base = vector.subtract(vector.new(1, 1, 1), vector.apply(particles_speed, math.abs))
    local minpos = vector.multiply(pos_base, -0.5)
    local maxpos = vector.multiply(pos_base, 0.5)
    if node.name == "superquest:quest_machine" then
        minpos = vector.add(minpos, vector.divide(particles_speed, 2))
        maxpos = vector.add(maxpos, vector.divide(particles_speed, 2))
    end

    core.add_particlespawner({
        amount = 50,
        time = 0.01,
        minpos = vector.add(pos, minpos),
        maxpos = vector.add(pos, maxpos),
        minvel = vector.multiply(particles_speed, 0.5),
        maxvel = vector.multiply(particles_speed, 2),
        minacc = vector.new(0, -9.8, 0),
        maxacc = vector.new(0, -9.8, 0),
        minexptime = 2,
        maxexptime = 2,
        minsize = 0.4,
        maxsize = 0.4,
        texture = "superquest_particle_red.png"
    })

    core.add_particlespawner({
        amount = 50,
        time = 0.01,
        minpos = vector.add(pos, minpos),
        maxpos = vector.add(pos, maxpos),
        minvel = vector.multiply(particles_speed, 0.5),
        maxvel = vector.multiply(particles_speed, 2),
        minacc = vector.new(0, -9.8, 0),
        maxacc = vector.new(0, -9.8, 0),
        minexptime = 2,
        maxexptime = 2,
        minsize = 0.4,
        maxsize = 0.4,
        texture = "superquest_particle_green.png"
    })

    core.add_particlespawner({
        amount = 50,
        time = 0.01,
        minpos = vector.add(pos, minpos),
        maxpos = vector.add(pos, maxpos),
        minvel = vector.multiply(particles_speed, 0.5),
        maxvel = vector.multiply(particles_speed, 2),
        minacc = vector.new(0, -9.8, 0),
        maxacc = vector.new(0, -9.8, 0),
        minexptime = 2,
        maxexptime = 2,
        minsize = 0.4,
        maxsize = 0.4,
        texture = "superquest_particle_blue.png"
    })
end

local on_punch = function(pos, node, puncher)
    if not (puncher and puncher:is_player()) then
        return
    end

    local res = module_args.try_to_receive_reward_handler(puncher, pos)
    if not res then
        return
    end

    show_particles(pos, node)

    superquest.hud.show_popup(puncher, S("Reward received!"))
end

local allow_metadata_inventory_put = function(pos, listname, item, stack, player)
    if not (player and player:is_player()) then
        return 0
    end

    local meta = core.get_meta(pos)
    local owner = meta:get_string("owner")
    local network = meta:get_string("network")
    local player_name = player:get_player_name()

    if stack:get_wear() ~= 0 then
        core.chat_send_player(player_name, S("You cannot use tools with wear"))
        return 0
    end

    if module_args.is_owner_mode_for_player(owner, network, player_name) then
        if listname == "reward_box_storage" then
            return stack:get_count()
        else
            if stack:get_name() == "superquest:certificate" then
                return 0
            end
            local inv = meta:get_inventory()
            local cur_stack = inv:get_stack(listname, item)
            local new_stack
            if stack:get_name() == "superquest:certificate_blank" then
                new_stack = ItemStack("superquest:certificate")
            else
                new_stack = ItemStack(stack)
            end
            if cur_stack:get_name() == new_stack:get_name() then
                local final_count = cur_stack:get_count() + new_stack:get_count()
                if final_count > new_stack:get_stack_max() then
                    final_count = new_stack:get_stack_max()
                end
                new_stack:set_count(final_count)
            end
            inv:set_stack(listname, item, new_stack)
        end
    end

    return 0
end

local allow_metadata_inventory_take = function(pos, listname, item, stack, player)
    if not (player and player:is_player()) then
        return 0
    end

    local meta = core.get_meta(pos)
    local owner = meta:get_string("owner")
    local network = meta:get_string("network")
    local player_name = player:get_player_name()

    if module_args.is_owner_mode_for_player(owner, network, player_name) then
        if listname == "reward_box_storage" then
            return stack:get_count()
        else
            local inv = meta:get_inventory()
            local cur_stack = inv:get_stack(listname, item)
            if cur_stack:get_count() > stack:get_count() then
                local new_stack = ItemStack(cur_stack)
                new_stack:set_count(cur_stack:get_count() - stack:get_count())
                inv:set_stack(listname, item, new_stack)
            else
                inv:set_stack(listname, item, ItemStack())
            end
        end
    end

    return 0
end

local allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
    if not (player and player:is_player()) then
        return 0
    end

    local meta = core.get_meta(pos)
    local owner = meta:get_string("owner")
    local network = meta:get_string("network")
    local player_name = player:get_player_name()

    if module_args.is_owner_mode_for_player(owner, network, player_name) then
        local inv = meta:get_inventory()
        local from_stack = inv:get_stack(from_list, from_index)
        local to_stack = inv:get_stack(to_list, to_index)

        if from_list == "reward_box_storage" and to_list ~= "reward_box_storage" then
            if from_stack:get_name() == "superquest:certificate" then
                return 0
            end
            local new_stack
            if from_stack:get_name() == "superquest:certificate_blank" then
                new_stack = ItemStack("superquest:certificate")
                count = 1
            else
                new_stack = ItemStack(from_stack)
            end
            if new_stack:get_name() == to_stack:get_name() then
                local final_count = count + to_stack:get_count();
                if final_count > to_stack:get_stack_max() then
                    final_count = to_stack:get_stack_max()
                end
                new_stack:set_count(final_count)
            else
                new_stack:set_count(count)
            end
            inv:set_stack(to_list, to_index, new_stack)
        elseif from_list ~= "reward_box_storage" and to_list == "reward_box_storage" then
            if from_stack:get_count() > count then
                local new_stack = ItemStack(from_stack)
                new_stack:set_count(from_stack:get_count() - count)
                inv:set_stack(from_list, from_index, new_stack)
            else
                inv:set_stack(from_list, from_index, ItemStack())
            end
        else
            return count
        end
    end

    return 0
end

core.register_node("superquest:quest_machine", {
    description = S("Quest Machine"),
    tiles = {
        "superquest_qmachine_sides.png",
        "superquest_qmachine_sides.png",
        "superquest_qmachine_sides.png",
        "superquest_qmachine_sides.png",
        "superquest_qmachine_sides.png",
        "superquest_qmachine_front.png"
    },
    groups = { cracky = 3 },
    paramtype2 = "facedir",

    digilines = {
        receptor = {}
    },

    can_dig = can_dig,
    after_place_node = after_place_node,
    on_rightclick = on_rightclick,
    on_destruct = on_destruct,
    on_punch = on_punch,
    allow_metadata_inventory_put = allow_metadata_inventory_put,
    allow_metadata_inventory_take = allow_metadata_inventory_take,
    allow_metadata_inventory_move = allow_metadata_inventory_move,
})
-- For backward compatibility
core.register_alias("superquest:reward_box", "superquest:quest_machine")

core.register_node("superquest:quest_machine_flat", {
    description = S("Flat Quest Machine"),
    tiles = {
        "superquest_qmachine_sides_flat_a.png",
        "superquest_qmachine_sides_flat_a.png",
        "superquest_qmachine_sides_flat_b.png",
        "superquest_qmachine_sides_flat_b.png",
        "superquest_qmachine_sides.png",
        "superquest_qmachine_front.png"
    },
    groups = { cracky = 3 },
    paramtype = "light",
    paramtype2 = "facedir",
    sunlight_propagates = true,
    drawtype = "nodebox",
    node_box = { type = "fixed", fixed = { -0.5, -0.5, -0.0, 0.5, 0.5, 0.5 } },

    digilines = {
        receptor = {}
    },

    can_dig = can_dig,
    after_place_node = after_place_node,
    on_rightclick = on_rightclick,
    on_destruct = on_destruct,
    on_punch = on_punch,
    allow_metadata_inventory_put = allow_metadata_inventory_put,
    allow_metadata_inventory_take = allow_metadata_inventory_take,
    allow_metadata_inventory_move = allow_metadata_inventory_move,
})
-- For backward compatibility
core.register_alias("superquest:reward_box_flat", "superquest:quest_machine_flat")

module_ret.is_quest_machine = function(node_name)
    return node_name == "superquest:quest_machine" or node_name == "superquest:quest_machine_flat"
end

if superquest.config.teleportation then
    module_ret.get_tp_destination = function(owner, network)
        local pos = module_args.get_quest_machine_coords(owner, network)
        if not pos then
            return nil
        end
        local node = superquest.utils.get_node(pos)
        if not module_ret.is_quest_machine(node.name) then
            return nil
        end

        return pos + facedir_to_front_dir_vector(node.param2)
    end
end

return module_ret
