local S = superquest.S

local guide_form_name = core.get_current_modname()..":digilines_guide"

superquest.digilines = {
    send = {},
    parse = {}
}

superquest.digilines.max_channel_length = 255
local max_player_name_length = 255

local esc = core.formspec_escape

local formspec_guide_text = "==================================================\n"..
                            S("Events of flags (including digiline-requiring)") .."\n"..
                            "==================================================\n\n"..
                            S("A player has just punched the flag")..":\n"..
                            esc("{\n"..
                            "    action = \"punched\",\n"..
                            "    player_name = \"<").. S("Name of the player")..esc(">\",\n"..
                            "    result = \"<").. S("Result")..esc(">\",\n"..
                            "    flags = {\n"..
                            "        triggered = <").. S("Number of triggered flags")..esc(">,\n"..
                            "        total = <").. S("Total number of flags")..esc(">\n"..
                            "    }\n"..
                            "}\n")..
                            S("where <Result> is one of the following values")..":\n"..
                            "- \"triggered\" - "..S("the flag has just been triggered (including automatic triggering)")..esc(";").."\n"..
                            "- \"not_started\" - "..S("the timed quest is not started")..esc(";").."\n"..
                            "- \"reached_max_completions\" - "..S("the maximum number of completions is reached")..esc(";").."\n"..
                            "- \"already_counted\" - "..S("the flag is already counted")..esc(";").."\n"..
                            "- \"missed_previous\" - "..S("previous flags were missed (not triggered)")..esc(";").."\n"..
                            "- \"no_digiline_signal\" - "..S("the digiline-requiring flag was punched without the corresponding digiline signal")..".\n"..
                            S("In case of triggering, the flag also sends a message with action @= \"triggering\" for backward compatibility. This message is deprecated, and will be removed in the future.").."\n"..
                            "\n"..
                            "==================================================\n"..
                            S("Requests for digiline-requiring flags") .."\n"..
                            "==================================================\n\n"..
                            S("Allow a particular player to trigger the flag")..":\n"..
                            esc("{\n"..
                            "    action = \"allow_player\",\n"..
                            "    player_name = \"<").. S("Name of the player")..esc(">\",\n"..
                            "}\n")..
                            "\n"..
                            S("Revoke permission for a particular player to trigger the flag")..":\n"..
                            esc("{\n"..
                            "    action = \"revoke_allow_player\",\n"..
                            "    player_name = \"<").. S("Name of the player")..esc(">\",\n"..
                            "}\n")..
                            "\n"..
                            "==================================================\n"..
                            S("Events of quest machines") .."\n"..
                            "==================================================\n\n"..
                            S("A player has just started the quest")..":\n"..
                            esc("{\n"..
                            "    action = \"quest_started\",\n"..
                            "    player_name = \"<").. S("Name of the player")..esc(">\",\n"..
                            "}\n")..
                            "\n"..
                            S("A player has just received the reward")..":\n"..
                            esc("{\n"..
                            "    action = \"reward_received\",\n"..
                            "    player_name = \"<").. S("Name of the player")..esc(">\",\n"..
                            "    completion = <").. S("Number of current completion")..esc(">\n"..
                            "}\n")

local formspec_guide =
        "formspec_version[4]" ..
        "size[11,12]" ..
        "style_type[label;font=mono,bold;font_size=32]" ..
        "style_type[textarea;font=mono]" ..
        "label[1.5,0.8;SuperQuest Digiline Guide]" ..
        "textarea[0.5,1.5;10,9;;;"..formspec_guide_text.."]" ..
        "button_exit[0.5,11;10,0.8;close;"..S("Close").."]"

function superquest.digilines.open_guide_formspec(player_name)
    core.show_formspec(player_name, guide_form_name, formspec_guide)
end

local function send_message(pos, channel, msg)
    digilines.receptor_send(pos, digilines.rules.default, channel, msg)
end

function superquest.digilines.send.flag_punched(pos, channel, player_name, result, triggered, total)
    local msg = {
        action = "punched",
        player_name = player_name,
        result = result,
        flags = {
            triggered = triggered,
            total = total
        }
    }
    send_message(pos, channel, msg)

    -- for backward compatibility, deprecated
    if result == "triggered" then
        msg = {
            action = "triggered",
            player_name = player_name,
            flags = {
                triggered = triggered,
                total = total
            }
        }
        send_message(pos, channel, msg)
    end
end

function superquest.digilines.send.quest_started(pos, channel, player_name)
    local msg = {
        action = "quest_started",
        player_name = player_name
    }
    send_message(pos, channel, msg)
end

function superquest.digilines.send.reward_received(pos, channel, player_name, completion)
    local msg = {
        action = "reward_received",
        player_name = player_name,
        completion = completion
    }
    send_message(pos, channel, msg)
end

function superquest.digilines.parse.flag_digiline_requiring(handlers, pos, msg)
    if type(msg) ~= "table" or type(msg.action) ~= "string" then
        return
    end

    if msg.action == "allow_player" then
        if type(msg.player_name) ~= "string" or msg.player_name == "" or #msg.player_name > max_player_name_length then
            return
        end
        handlers.allow_player(pos, msg.player_name)
    elseif msg.action == "revoke_allow_player" then
        if type(msg.player_name) ~= "string" or msg.player_name == "" or #msg.player_name > max_player_name_length then
            return
        end
        handlers.revoke_allow_player(pos, msg.player_name)
    end
end
