local module_args = ...

assert(module_args.reset_completions_handler)

local module_ret = {}

local S = superquest.S

local form_name_completions = core.get_current_modname()..":quest_machine_completions"

local node_positions = {}

local function get_completions_formspec(completions, is_owner)
    local height_cur = 0
    local formspec_data = ""

    formspec_data = formspec_data ..
        "tablecolumns[text;text]" ..
        "table[0,"..tostring(height_cur)..";9,7.3;compl_list;"
    for k, v in pairs(completions) do
        formspec_data = formspec_data .. core.formspec_escape(k) .. "," .. core.formspec_escape(v) .. ","
    end
    formspec_data = formspec_data .. ";1]"
    height_cur = height_cur + 7.5

    formspec_data = formspec_data ..
        "button_exit[0,"..tostring(height_cur)..";9,0.8;close;"..S("Close").."]"
    height_cur = height_cur + 1

    if is_owner then
        formspec_data = formspec_data ..
            "button_exit[0,"..tostring(height_cur)..";9,0.8;reset_completions;"..S("Reset Completions").."]"
        height_cur = height_cur + 1
    end

    formspec_data =
        "formspec_version[4]" ..
        "size[10,"..tostring(height_cur + 0.5).."]" ..
        "container[0.5,0.5]" ..
        formspec_data ..
        "container_end[]"

    return formspec_data
end

module_ret.show = function(player_name, pos, completions, is_owner)
    node_positions[player_name] = pos

    core.show_formspec(player_name, form_name_completions, get_completions_formspec(completions, is_owner))
end

core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= form_name_completions then
        return false
    end

    if not (player and player:is_player()) then
        return true
    end

    local player_name = player:get_player_name()

    local pos = node_positions[player_name]
    if pos == nil then
        return true
    end

    if fields.reset_completions then
        module_args.reset_completions_handler(player, pos)
    end

    return true
end)

return module_ret
