local module_ret = {}

module_ret.calc_avail_rewards_for_inventory = function(rewards_inv, quest_machine_inventory)
    local available_rewards
    for k_item, v_item in pairs(rewards_inv) do
        if k_item == "superquest:certificate" then
            k_item = "superquest:certificate_blank"
        end

        if not quest_machine_inventory[k_item] then
            return 0
        end

        local avail_cur_item_times
        if v_item.no_meta ~= 0 then
            avail_cur_item_times = quest_machine_inventory[k_item].no_meta / v_item.no_meta

            if available_rewards == nil or avail_cur_item_times < available_rewards then
                available_rewards = avail_cur_item_times
            end
            if available_rewards == 0 then
                return 0
            end
        end

        if #v_item.with_meta > 0 then
            for _, v_item_meta1 in ipairs(v_item.with_meta) do
                local is_found = false
                for _, v_item_meta2 in ipairs(quest_machine_inventory[k_item].with_meta) do
                    if v_item_meta1.meta_itemstack:get_meta():equals(v_item_meta2.meta_itemstack:get_meta()) then
                        avail_cur_item_times = v_item_meta2.count / v_item_meta1.count
                        if available_rewards == nil or avail_cur_item_times < available_rewards then
                            available_rewards = avail_cur_item_times
                        end
                        if available_rewards == 0 then
                            return 0
                        end
                        is_found = true

                        break
                    end
                end
                if not is_found then
                    return 0
                end
            end
        end
    end

    if available_rewards == nil then
        available_rewards = 0
    end

    return math.floor(available_rewards)
end

module_ret.calc_items_in_inv_list = function(inv_list)
    local items_count = {}
    for _, stack_v in pairs(inv_list) do
        if not stack_v:is_empty() then
            items_count[stack_v:get_name()] = items_count[stack_v:get_name()] or {
                no_meta = 0,
                with_meta = {}
            }
            local item_total_data = items_count[stack_v:get_name()]
            if #stack_v:get_meta():get_keys() == 0 then
                item_total_data.no_meta = item_total_data.no_meta + stack_v:get_count()
            else
                local found_meta_total_data = nil
                for _, item_meta_total_data in ipairs(item_total_data.with_meta) do
                    if item_meta_total_data.meta_itemstack:get_meta():equals(stack_v:get_meta()) then
                        found_meta_total_data = item_meta_total_data
                        break
                    end
                end
                if not found_meta_total_data then
                    local stack_to_insert = {
                        count = stack_v:get_count(),
                        meta_itemstack = ItemStack({
                            name = stack_v:get_name(),
                            count = 1
                        })
                    }
                    stack_to_insert.meta_itemstack:get_meta():from_table(stack_v:get_meta():to_table())
                    table.insert(item_total_data.with_meta, stack_to_insert)
                else
                    found_meta_total_data.count = found_meta_total_data.count + stack_v:get_count()
                end
            end
        end
    end

    return items_count
end

module_ret.is_enough_place_for_reward = function(reward_inv_list, user_inv_list)
    local items_count = module_ret.calc_items_in_inv_list(reward_inv_list)

    local empty_cells_in_user_inv = 0
    local avail_for_items = {}

    for _, stack in pairs(user_inv_list) do
        if stack:is_empty() then
            empty_cells_in_user_inv = empty_cells_in_user_inv + 1
        elseif items_count[stack:get_name()] ~= nil and stack:get_count() < stack:get_stack_max() then
            avail_for_items[stack:get_name()] = avail_for_items[stack:get_name()] or {
                no_meta = 0,
                with_meta = {}
            }
            local item_total_data = avail_for_items[stack:get_name()]
            if #stack:get_meta():get_keys() == 0 then
                item_total_data.no_meta = item_total_data.no_meta + stack:get_stack_max() - stack:get_count()
            else
                local found_meta_total_data = nil
                for _, item_meta_total_data in ipairs(item_total_data.with_meta) do
                    if item_meta_total_data.meta_itemstack:get_meta():equals(stack:get_meta()) then
                        found_meta_total_data = item_meta_total_data
                        break
                    end
                end
                if not found_meta_total_data then
                    local stack_to_insert = {
                        count = stack:get_stack_max() - stack:get_count(),
                        meta_itemstack = ItemStack({
                            name = stack:get_name(),
                            count = 1
                        })
                    }
                    stack_to_insert.meta_itemstack:get_meta():from_table(stack:get_meta():to_table())
                    table.insert(item_total_data.with_meta, stack_to_insert)
                else
                    found_meta_total_data.count = found_meta_total_data.count + stack:get_stack_max() - stack:get_count()
                end
            end
        end
    end

    for k, v in pairs(items_count) do
        local cur_items_remaining = v
        if avail_for_items[k] ~= nil then
            cur_items_remaining.no_meta = cur_items_remaining.no_meta - math.min(cur_items_remaining.no_meta, avail_for_items[k].no_meta)
            for _, v_meta_src in ipairs(cur_items_remaining.with_meta) do
                for _, v_meta_dst in ipairs(avail_for_items[k].with_meta) do
                    if v_meta_src.meta_itemstack:get_meta():equals(v_meta_dst.meta_itemstack:get_meta()) then
                        v_meta_src.count = v_meta_src.count - math.min(v_meta_src.count, v_meta_dst.count)
                        break
                    end
                end
            end
        end

        local max_stack_size = ItemStack(k):get_stack_max()

        if empty_cells_in_user_inv < cur_items_remaining.no_meta / max_stack_size then
            return false
        end
        empty_cells_in_user_inv = empty_cells_in_user_inv - math.ceil(cur_items_remaining.no_meta / max_stack_size)

        for _, v_meta in ipairs(cur_items_remaining.with_meta) do
            if empty_cells_in_user_inv < v_meta.count / max_stack_size then
                return false
            end
            empty_cells_in_user_inv = empty_cells_in_user_inv - math.ceil(v_meta.count / max_stack_size)
        end

        -- We don't need to update avail_for_items for the current item here since we won't need it anymore
    end

    return true
end

module_ret.remove_item_metadata_aware = function(inv, listname, stack)
    local stack_remaining = ItemStack(stack)

    if stack_remaining:is_empty() then
        return
    end

    for i = 1, inv:get_size(listname) do
        local cur_stack = inv:get_stack(listname, i)
        if not cur_stack:is_empty() and cur_stack:get_name() == stack_remaining:get_name() and cur_stack:get_meta():equals(stack_remaining:get_meta()) then
            local smallest_count = math.min(cur_stack:get_count(), stack_remaining:get_count())
            cur_stack:set_count(cur_stack:get_count() - smallest_count)
            stack_remaining:set_count(stack_remaining:get_count() - smallest_count)
            inv:set_stack(listname, i, cur_stack)

            if stack_remaining:is_empty() then
                break
            end
        end
    end
end

return module_ret
