package.path = "../?.lua;" .. package.path

dofile('tests/mut.lua')
dofile('tests/mut_deps.lua')

local version_1_data = {
    fields = {
        ["network#user1#test_quest"] = {
            flags = {
                ["(15301, 0, -7156)"] = {
                    players_reached = {
                        user1 = 1,
                        some_player = 1,
                        another_player = 1,
                    }
                },
                ["(-4589, -3430, -30001)"] = {
                    players_reached = {}
                }
            },
            reward_boxes = {
                ["(5610, 500, 100)"] = {
                    completions = {
                        some_player = 3,
                        another_player = 1
                    }
                }
            },
        },
        ["network#player#test_quest"] = {
            flags = {
                ["(0, 0, 0)"] = {
                    players_reached = {
                        some_player = 1,
                    }
                }
            }
        },
        ["network#player#test_quest2"] = {
            reward_boxes = {
                ["(5, 6, 7)"] = {
                    completions = {
                        another_player = 5
                    }
                }
            }
        },
        ["network#~!@$%^&*()_+-=,./;:'\"[{}]\\|?`#~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = {
            flags = {
                ["(7, 1, 2)"] = {
                    players_reached = {
                        some_player = 1,
                        ["~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = 1
                    }
                }
            },
            reward_boxes = {
                ["(-10000, -10000, -10000)"] = {
                    completions = {
                        player = 8,
                        ["~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = 5
                    }
                }
            },
            user_mode = 1,
            reward_boxes_count = 1,
            params = {
                timed_duration = 300,
                teleport_after_compl = true
            }
        },
        ["network#player#nonexistent"] = {
            user_mode = 1,
            reward_boxes_count = 1,
            params = {
                timed_duration = 300,
                teleport_after_compl = true
            }
        },
        format_version = 2
    }
}

for k, v in pairs(version_1_data.fields) do
    if k:match("^network#") then
        version_1_data.fields[k] = core.serialize(version_1_data.fields[k])
    end
end

insulate("Migrate from 1 to latest", function()
    it("Migrate from 1 to latest", function()
        local version_latest_exp = {
            fields = {
                ["network#user1#test_quest"] = {
                    flags = {
                        ["(15301, 0, -7156)"] = {
                            players_reached = {
                                user1 = true,
                                some_player = true,
                                another_player = true,
                            }
                        },
                        ["(-4589, -3430, -30001)"] = {
                            players_reached = {}
                        }
                    },
                    quest_machine = {
                        coords = "(5610, 500, 100)",
                        completions = {
                            some_player = 3,
                            another_player = 1
                        }
                    }
                },
                ["network#player#test_quest"] = {
                    flags = {
                        ["(0, 0, 0)"] = {
                            players_reached = {
                                some_player = true,
                            }
                        }
                    }
                },
                ["network#player#test_quest2"] = {
                    quest_machine = {
                        coords = "(5, 6, 7)",
                        completions = {
                            another_player = 5
                        }
                    }
                },
                ["network#~!@$%^&*()_+-=,./;:'\"[{}]\\|?`#~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = {
                    flags = {
                        ["(7, 1, 2)"] = {
                            players_reached = {
                                some_player = true,
                                ["~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = true
                            }
                        }
                    },
                    quest_machine = {
                        coords = "(-10000, -10000, -10000)",
                        completions = {
                            player = 8,
                            ["~!@$%^&*()_+-=,./;:'\"[{}]\\|?`"] = 5
                        },
                        user_mode = true,
                        params = {
                            timed_duration = 300,
                            teleport_after_compl = true
                        }
                    }
                },
                format_version = 3
            }
        }

        mut.set_mod_storage_data(version_1_data)

        dofile('init.lua')

        local version_latest_real = mut.get_mod_storage_data()

        for k, v in pairs(version_latest_real.fields) do
            if k:match("^network#") then
                version_latest_real.fields[k] = core.deserialize(version_latest_real.fields[k])
            end
        end

        assert(mut.compare_objects(version_latest_exp, version_latest_real))
    end)
end)
