## Sound Pack for Minetest

### Description:

A [Minetest][] mod that provides a set of free sounds & methods. It is intended as a more universal method for adding sounds to games rather than depending on [MTG & default][default] for sounds only.

<img src="screenshot.png" alt="icon" width="200" />

### Licensing:

- Code: [MIT](LICENSE.txt)
- Icon/Screenshot: [CC0](https://openclipart.org/detail/260975)
- Media: see following table

#### Sound file sources & licensing:<a name="sources" />

##### General Sounds:

| Filename (sounds_) / Source       | Author                       | License      | Notes                   |
| --------------------------------- | ---------------------------- | ------------ | ----------------------- |
| [apple_bite][]                    | sonicmariobrotha             | CC0          |                         |
| [bat*][bat]                       | polymorpheva                 | CC0          |                         |
| [bear*][bear]                     | U.S. Fish & Wildlife Service | CC0          |                         |
| [bee][]                           | DrDufus                      | CC0          |                         |
| [bees][]                          | tom_woysky                   | CC0          |                         |
| [bird*][bird]                     | Jc Guan                      | CC0          |                         |
| [boing][]                         | reelworldstudio              | CC0          |                         |
| [bumble_bee_01][]                 | Iain McCurdy                 | CC BY 3.0    |                         |
| [bumble_bee_02][]                 | CGEffex                      | CC BY 3.0    |                         |
| [camel*][camel]                   | craigsmith                   | CC0          |                         |
| [canary*][canary]                 | MediaCollege.com             | CC0          |                         |
| [cat_meow][]                      | blimp66                      | CC BY 3.0    |                         |
| [chicken*][chicken]               | www.bonson.ca                | CC BY 3.0    |                         |
| [clock_tick][]                    | AntumDeluge                  | CC0          |                         |
| [coin][]                          | greenvwbeetle                | CC0          |                         |
| [cow_moo*][cow_moo]               | JosephSardin                 | CC0          |                         |
| [coyote_howl][]                   | rogerforeman                 | CC BY 3.0    |                         |
| [cricket][]                       | GB01                         | CC0          |                         |
| [crow_caw][]                      | Morris Gevirtz               | CC BY 4.0    |                         |
| [dog_bark][]                      | ivolipa                      | CC0          |                         |
| [duck_quack][]                    | Jonathon Jongsma             | CC BY-SA 3.0 |                         |
| [elephant_trumpet][]              | vataaa                       | CC0          |                         |
| [entity_hit][]                    | sonictechtonic               | CC BY 3.0    |                         |
| [explosion][]                     | JuveriSetila                 | CC0          |                         |
| [frog][]                          | kayceemixer                  | CC0          |                         |
| [fuse][]                          | Ned Bouhalassa               | CC0          |                         |
| [gallop_01][]                     | Alan McKinney (alanmcki)     | CC BY 3.0    |                         |
| [gallop_02][]                     | Alan McKinney (alanmcki)     | CC BY 3.0    |                         |
| [giraffe_hum][]                   | [↓](#authors)                | CC BY-SA 4.0 |                         |
| [goat_bleat*][goat_bleat]         | Stephan                      | CC0          |                         |
| [gorilla_grunt][]                 | [↓](#authors)                | CC0          |                         |
| [gorilla_roar][]                  | J0ck0                        | CC0          |                         |
| [gorilla_snarl*][gorilla_grunt]   | [↓](#authors)                | CC0          |                         |
| [grasshopper][]                   | straget                      | CC0          |                         |
| [horse_neigh_01][]                | GoodListener                 | CC BY 3.0    |                         |
| [horse_neigh_02][]                | foxen10                      | CC0          |                         |
| [horse_snort_01][]                | madklown                     | CC0          |                         |
| [horse_snort_02][]                | 0_ciz                        | CC0          |                         |
| [hyena_01][]                      | [↓](#authors)                | CC BY 2.0    |                         |
| [hyena_02][]                      | [↓](#authors)                | CC BY 2.0    |                         |
| [hyena_03][]                      | [↓](#authors)                | CC BY 2.0    |                         |
| [jaguar_saw][]                    | About Zoos                   | CC BY        |                         |
| [lion_bellow][]                   | felix.blume                  | CC0          |                         |
| [monkey*][monkey]                 | AntumDeluge                  | CC0          | imitation               |
| [mouse][]                         | AntumDeluge                  | CC0          | imitation               |
| [owl_hoot][]                      | Anthousai                    | CC0          |                         |
| [parrot*][parrot]                 | Mings                        | CC BY 3.0    |                         |
| [peacock_01][]                    | dobroide                     | CC BY 3.0    |                         |
| [peacock_02][]                    | MediaCollege.com             | CC0          |                         |
| [pencil_erase][]                  | damsur                       | CC0          |                         |
| [pencil_write][]                  | NachtmahrTV                  | CC0          |                         |
| [penguin*][penguin]               | Bidone                       | CC0          |                         |
| [piano][]                         | [↓](#authors)                | CC0          |                         |
| [pig_snort][]                     | yottasounds                  | CC BY 3.0    |                         |
| [pig_squeal][]                    | MediaCollege.com             | CC0          |                         |
| [pigeon][]                        | JavierSerrat                 | CC0          |                         |
| [puppy_bark][]                    | moffet                       | CC0          |                         |
| [quail][]                         | PrincessGrace                | CC0          |                         |
| [rooster][]                       | poorenglishjuggler           | CC0          |                         |
| [sheep][]                         | mikewest                     | CC0          |                         |
| [skeleton_bones][]                | AntumDeluge                  | CC0          |                         |
| [tiger_roar_01][]                 | videog                       | CC BY 3.0    |                         |
| [tiger_snarl_01][tiger_roar_01]   | videog                       | CC BY 3.0    |                         |
| [tiger_snarl_0[2-4]][tiger_snarl] | schots                       | CC0          |                         |
| [toucan][]                        | Niels Krabbe                 | CC BY-SA 4.0 |                         |
| [turkey_gobble][]                 | JarredGibb                   | CC0          |                         |
| [undead_moan_*][undead_moan]      | AntumDeluge                  | CC0          |                         |
| [vulture][]                       | AntumDeluge                  | CC0          | imitation               |
| [watch_tick][]                    | Nicolas4677                  | CC0          |                         |
| [whistle][]                       | pawsound                     | CC0          |                         |
| [wolf_howl][]                     | killyourpepe                 | CC0          |                         |
| [wolf_snarl][]                    | newagesoup                   | CC BY 3.0    |                         |
| [yak][]                           | AntumDeluge                  | CC0          | imitation               |
| [zebra][]                         | Peet J van Eeden             | CC BY        |                         |
| [zipper][]                        | AntumDeluge                  | CC0          |                         |

##### Node Sounds:

| Filename (sounds_node_) / Source  | Author                   | License      | Notes                   |
| --------------------------------- | ------------------------ | ------------ | ----------------------- |
| [dig_choppy.*][dig_choppy]        | Sheyvan                  | CC0          |                         |
| [dig_cracky.*][dig_cracky]        | Benboncan                | CC BY 3.0    |                         |
| [dig_crumbly][default]            | Mito551                  | CC BY-SA 3.0 |                         |
| [dig_gravel.*][dig_gravel]        | lolamadeus               | CC0          |                         |
| [dig_ice.*][dig_ice]              | dheming                  | CC BY 3.0    |                         |
| [dig_metal][]                     | yadronoff                | CC BY 3.0    |                         |
| [dig_snappy][]                    | blukotek                 | CC0          |                         |
| [dug.*][default]                  | Mito551                  | CC BY-SA 3.0 |                         |
| [dug_glass.1][]                   | cmusounddesign           | CC BY 3.0    |                         |
| [dug_glass.2][]                   | Tomlija                  | CC BY 3.0    |                         |
| [dug_glass.3][]                   | lsprice                  | CC BY 3.0    |                         |
| [dug_gravel.*][dig_gravel]        | lolamadeus               | CC0          |                         |
| [dug_ice][]                       | Angel_Perez_Grandi       | CC BY 3.0    |                         |
| [dug_metal.*][dug_metal]          | qubodup                  | CC0          |                         |
| [place*][default]                 | Mito551                  | CC BY-SA 3.0 |                         |
| [place_metal.*][place_metal]      | Ogrebane                 | CC0          |                         |
| [step_dirt.*][default]            | Mito551                  | CC BY-SA 3.0 |                         |
| [step_glass][default]             | Mito551                  | CC BY-SA 3.0 |                         |
| [step_grass.*][default]           | Mito551                  | CC BY-SA 3.0 |                         |
| [step_gravel][default]            | Mito551                  | CC BY-SA 3.0 |                         |
| [step_hard.*][step_hard]          | Erdie                    | CC BY 3.0    |                         |
| [step_ice.*][step_ice]            | InspectorJ               | CC BY 3.0    |                         |
| [step_metal.*][step_metal]        | mypantsfelldown          | CC0          |                         |
| [step_sand.*][step_sand]          | worthahep88              | CC0          |                         |
| [step_snow.*][step_snow]          | Ryding                   | CC0          |                         |
| [step_water.1][]                  | AGFX                     | CC BY 3.0    |                         |
| [step_water.2][]                  | AGFX                     | CC BY 3.0    |                         |
| [step_water.3][]                  | AGFX                     | CC BY 3.0    |                         |
| step_water.4                      | AntumDeluge              | CC0          | generated with Audacity |
| [step_wood.*][default]            | Mito551                  | CC BY-SA 3.0 |                         |

<a name="authors">**Authors Continued:**</a>

- Anton Baotic, Florian Sicks, & Angela S. Stoeger:
	- **giraffe_hum**
	- **gorilla_grunt**
	- **gorilla_snarl**
- **hyena:** Mathevon N, Koralek A, Weldele M, Glickman S, & Theunissen F
- **piano:** Scott Joplin & Tim Starling

### Usage:

#### Replacement for default:

If your mod depends on *default* for node sounds only, then you can easily switch to *sounds*. Simply add *default* & *sounds* as optional dependencies in your *mod.conf*. *sounds* overrides methods used by *default* to its own. For example *default.node_sound_dirt_defaults*.

Example of overidden method:
```lua
function sounds.node_dirt(tbl)
	tbl = tbl or {}

	tbl.footstep = tbl.footstep or {name="sounds_dirt_step", gain=0.4}
	tbl.dug = tbl.dug or {name="sounds_dirt_step", gain=1.0}
	tbl.place = tbl.place or {name="sounds_node_place_soft", gain=1.0}

	sounds.node(tbl)
	return tbl
end

default.node_sound_dirt_defaults = sounds.node_dirt
```

Example of setting node sounds:
```lua
minetest.register_node("foo:bar", {
	description = "Foo Node",
	sounds = default.node_sound_stone_defaults() -- this is the same as calling `sounds.node_stone()`
	...
})
```

#### Playing Sounds Manually:

`SoundGroup` instances are objects for storing & playing sounds. These objects can be called to play a sound from their group. An index can be specified when called to determine which sound to play. If the index parameter is omitted, a random sound will be picked. A table of arguments can also be passed. This is compatible with [SimpleSoundSpec](https://minetest.gitlab.io/minetest/sounds/#simplesoundspec).

Creating `SoundGroup` objects:
```lua
local s_group1 = SoundGroup({"sound1", "sound2"})
local s_group2 = SoundGroup({"sound3", "sound4", "sound5"})

-- SoundGroup objects can be concatenated with the arithmetic operator
local s_group3 = s_group1 + s_group2

-- to prevent sound file names from being prefixed with "sounds_" when played, the `no_prepend` field must be set to `true`
s_group1(2) -- plays "sounds_sound2"

s_group1.no_prepend = true
s_group1(2) -- plays "sound2"
```

There are many [pre-defined sound groups](https://antummt.github.io/mod-sounds/reference/latest/topics/groups.html).

Calling a `SoundGroup` object:
```lua
-- play random sound from group
sounds.horse_neigh()

-- play specific sound from group
sounds.horse_neigh(2)

-- play random sound from group with parameters
sounds.horse_neigh({gain=1.0})

-- play specific sound from group with parameters
sounds.horse_neigh(2, {gain=1.0})

-- the `play` method is the same as calling the object directly
sounds.horse_neigh:play(2, {gain=1.0})
```

`SoundGroup` objects can also be used in node registration:
```lua
minetest.register_node("foo:bar", {
	description = "Foo Node",
	sounds = {
		dig = sounds.cow_moo, -- a random sound from the `sounds.cow_moo` group will be played when digging this node
	},
	...
```

Currently using `SoundGroup` for node sounds only works for "dig", "dug", & "place".

`SoundGroup` objects are tables & are indexed by integer. But using the `get` method is more reliable as it will return the string name with "sounds_" prefix if `no_prepend` isn't set:
```lua
local s_group1 = SoundGroup({"sound1", "sound2"})
local s1 = s_group1:get(1) -- returns "sounds_sound1"
local s2 = s_group1[2] -- returns "sound2"

local s_group2 = SoundGroup({"sound3", "sound4", no_prepend=true})
local s3 = s_group2:get(1) -- returns "sound3"
local s4 = s_group2[2] -- returns "sound4"
```

The built-in `type` function can be used to check for a `SoundGroup` instance:
```lua
if type(s_group1) == "SoundGroup" then
	s_group1()
end
```

### Links:

- [![ContentDB](https://content.minetest.net/packages/AntumDeluge/sounds/shields/title/)](https://content.minetest.net/packages/AntumDeluge/sounds/)
- [Forum](https://forum.minetest.net/viewtopic.php?t=26868)
- [Git repo](https://github.com/AntumMT/mod-sounds)
- [Reference](https://antummt.github.io/mod-sounds/reference/)
- [Changelog](changelog.txt)
- [TODO](TODO.txt)


[Minetest]: http://minetest.net/
[default]: https://github.com/minetest/minetest_game/tree/master/mods/default

[apple_bite]: https://freesound.org/s/333825/
[bat]: https://freesound.org/s/104205/
[bear]: https://www.fws.gov/video/sound.htm
[bee]: https://freesound.org/s/462875/
[bees]: https://freesound.org/s/243011/
[bird]: https://soundbible.com/340-Bird-Song.html
[boing]: https://freesound.org/s/161122/
[bumble_bee_01]: https://freesound.org/s/498412/
[bumble_bee_02]: https://freesound.org/s/99955/
[camel]: https://freesound.org/s/437937/
[canary]: https://www.mediacollege.com/downloads/sound-effects/animals/bird/
[cat_meow]: https://freesound.org/s/397661/
[chicken]: https://freesound.org/s/24967/
[clock_tick]: https://opengameart.org/node/16323
[coin]: https://freesound.org/s/423332/
[cow_moo]: https://freesound.org/s/177253/
[coyote_howl]: https://freesound.org/s/68067/
[cricket]: https://freesound.org/s/530477/
[crow_caw]: https://www.xeno-canto.org/617630
[dig_choppy]: https://freesound.org/s/476113/
[dig_cracky]: https://freesound.org/s/71823/
[dig_gravel]: https://freesound.org/s/179341/
[dig_ice]: https://freesound.org/s/268023/
[dig_metal]: https://freesound.org/s/320397/
[dig_snappy]: https://freesound.org/s/251660/
[dog_bark]: https://freesound.org/s/328730/
[duck_quack]: https://www.xeno-canto.org/62258
[dug_glass.1]: https://freesound.org/s/71947/
[dug_glass.2]: https://freesound.org/s/97669/
[dug_glass.3]: https://freesound.org/s/88808/
[dug_ice]: https://freesound.org/s/49190/
[dug_metal]: https://opengameart.org/node/18150
[elephant_trumpet]: https://freesound.org/s/148873/
[entity_hit]: https://freesound.org/s/241872/
[explosion]: https://freesound.org/s/514133/
[frog]: https://freesound.org/s/251495/
[fuse]: https://freesound.org/s/8320/
[gallop_01]: https://freesound.org/s/403026/
[gallop_02]: https://freesound.org/s/403025/
[giraffe_hum]: https://bmcresnotes.biomedcentral.com/articles/10.1186/s13104-015-1394-3#Sec10
[goat_bleat]: https://pdsounds.org/pdsounds_files/files/audio/ziegengatter.mp3
[gorilla_grunt]: https://www.mediacollege.com/downloads/sound-effects/animals/primates/
[gorilla_roar]: https://freesound.org/s/397054/
[grasshopper]: https://freesound.org/s/401939/
[horse_neigh_01]: https://freesound.org/s/322443/
[horse_neigh_02]: https://freesound.org/s/149024/
[horse_snort_01]: https://freesound.org/s/184503/
[horse_snort_02]: https://freesound.org/s/475480/
[hyena_01]: https://commons.wikimedia.org/wiki/File:Giggling_call_of_a_spotted_hyena_(Crocuta_crocuta)_-_1472-6785-10-9-S1.oga
[hyena_02]: https://commons.wikimedia.org/wiki/File:Giggling_call_of_a_spotted_hyena_(Crocuta_crocuta)_-_1472-6785-10-9-S3.oga
[hyena_03]: https://commons.wikimedia.org/wiki/File:Giggling_call_of_a_spotted_hyena_(Crocuta_crocuta)_-_1472-6785-10-9-S5.oga
[jaguar_saw]: https://www.youtube.com/watch?v=VJ0RCZXu0v4
[lion_bellow]: https://freesound.org/s/405211/
[monkey]: https://opengameart.org/node/81240
[mouse]: https://opengameart.org/node/16331
[owl_hoot]: https://freesound.org/s/398734/
[parrot]: https://freesound.org/s/160381/
[peacock_01]: https://freesound.org/s/59186/
[peacock_02]: https://www.mediacollege.com/downloads/sound-effects/animals/bird/
[pencil_erase]: https://freesound.org/s/443241/
[pencil_write]: https://freesound.org/s/571800/
[penguin]: https://freesound.org/s/66150/
[piano]: https://commons.wikimedia.org/wiki/File:Maple_leaf_rag.ogg
[pig_snort]: https://freesound.org/s/174615/
[pig_squeal]: https://www.mediacollege.com/downloads/sound-effects/animals/pig/
[pigeon]: https://freesound.org/s/524345/
[place_metal]: https://opengameart.org/node/3511
[puppy_bark]: https://freesound.org/s/583142/
[quail]: https://freesound.org/s/329371/
[rooster]: https://freesound.org/s/269496/
[step_hard]: https://freesound.org/s/41579/
[step_ice]: https://freesound.org/s/416967/
[step_metal]: https://freesound.org/s/398937/
[step_sand]: https://freesound.org/s/319224/
[step_snow]: https://freesound.org/s/94337/
[step_water.1]: https://freesound.org/s/20432/
[step_water.2]: https://freesound.org/s/20434/
[step_water.3]: https://freesound.org/s/20437/
[sheep]: https://freesound.org/s/414342/
[skeleton_bones]: https://opengameart.org/node/16324
[tiger_roar_01]: https://freesound.org/s/149190/
[tiger_snarl]: https://freesound.org/s/439280/
[toucan]: https://www.xeno-canto.org/250531
[turkey_gobble]: https://freesound.org/s/233125/
[undead_moan]: https://opengameart.org/node/81246
[vulture]: https://opengameart.org/node/16329
[watch_tick]: https://freesound.org/s/446611/
[whistle]: https://freesound.org/s/154873/
[wolf_howl]: https://freesound.org/s/395192/
[wolf_snarl]: https://freesound.org/s/338674/
[yak]: https://opengameart.org/node/98682
[zebra]: https://www.youtube.com/watch?v=xjGJ_XMVTRE
[zipper]: https://opengameart.org/node/16332
