
local uses = 45000

local switch = function (stack, player, target, pointed)
    -- Gather as much info as we can
    local node = minetest.get_node_or_nil(target)
    if node == nil then
        return
    end
    local nodedef = minetest.registered_nodes[node.name] or nil
    if nodedef == nil then
        return
    end
    local nodemeta = minetest.get_meta(target)
    if nodemeta == nil then
        return
    end
    -- Try to not switch on doors and chests and such
    if nodedef.on_rightclick ~= nil then
        return nodedef.on_rightclick(target, node, player, stack, pointed)
    end
    -- Switch only when needed
    local me = stack:get_name()
    local wear = stack:get_wear()
    if (nodedef.groups.cracky ~= nil or nodedef.groups.pickaxey ~= nil) and me ~= "omni_tool:pickaxe" then
        stack:replace("omni_tool:pickaxe 1 " .. tostring(wear))
    elseif (nodedef.groups.choppy ~= nil or nodedef.groups.axey ~= nil) and me ~= "omni_tool:axe" then
        stack:replace("omni_tool:axe 1 " .. tostring(wear))
    elseif (nodedef.groups.crumbly ~= nil or nodedef.groups.shovely ~= nil) and me ~= "omni_tool:shovel" then
        stack:replace("omni_tool:shovel 1 " .. tostring(wear))
    end
    return stack
end

local on_place = function (stack, placer, pointed)
    -- Switch to our axe on combat
    if pointed.type ~= "node" and stack:get_name() ~= "omni_tool:axe" then
        stack:replace("omni_tool:axe 1 " .. tostring(stack:get_wear()))
        return stack
    elseif pointed.type ~= "node" and stack:get_name() == "omni_tool:axe" then
        return
    end
    -- Cycle thru when sneaking
    local ctrl = placer:get_player_control()
    if ctrl.sneak then
        local me = stack:get_name()
        local wear = stack:get_wear()
        if me == "omni_tool:axe" then
            stack:replace("omni_tool:pickaxe 1 " .. tostring(wear))
            return stack
        elseif me == "omni_tool:pickaxe" then
            stack:replace("omni_tool:shovel 1 " .. tostring(wear))
            return stack
        elseif me == "omni_tool:shovel" then
            stack:replace("omni_tool:axe 1 " .. tostring(wear))
            return stack
        end
    end
    -- Detect what node it might be and select the right tool
    return switch(stack, placer, pointed.under, pointed)
end

local on_sec_place = function (stack, placer, pointed)
    -- Cycle thru
    local me = stack:get_name()
    local wear = stack:get_wear()
    if me == "omni_tool:axe" then
        stack:replace("omni_tool:pickaxe 1 " .. tostring(wear))
        return stack
    elseif me == "omni_tool:pickaxe" then
        stack:replace("omni_tool:shovel 1 " .. tostring(wear))
        return stack
    elseif me == "omni_tool:shovel" then
        stack:replace("omni_tool:axe 1 " .. tostring(wear))
        return stack
    end
end

minetest.register_tool("omni_tool:axe", {
    short_description = "Omni Tool",
    description = "Omni Tool\nAxe",
    inventory_image = "omni_tool_axe.png",
    groups = { tool=1, axe=1, dig_speed_class=5, enchantability=10 },
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 5,
        punch_attack_uses = uses,
        groupcaps = {
            choppy = {
                maxlevel = 3,
                uses = uses,
                times = { [1]=2.10, [2]=0.90, [3]=0.50 }
            },
        },
        damage_groups = {fleshy=9},
    },
    sound = { breaks = "default_tool_breaks" },
    _mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 8, level = 5, uses = uses }
	},
    on_place = on_place,
    on_secondary_use = on_sec_place,
})

minetest.register_tool("omni_tool:pickaxe", {
    short_description = "Omni Tool",
    description = "Omni Tool\nPickaxe",
    inventory_image = "omni_tool_pickaxe.png",
    groups = { tool=1, pickaxe=1, dig_speed_class=5, enchantability=10 },
    tool_capabilities = {
        full_punch_interval = 0.83333333,
        max_drop_level = 5,
        punch_attack_uses = uses,
        groupcaps = {
            cracky = {
                maxlevel = 3,
                uses = uses,
                times = { [1]=2.00, [2]=1.0, [3]=0.50 }
            },
        },
        damage_groups = {fleshy=5},
    },
    sound = { breaks = "default_tool_breaks" },
    _mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 8, level = 5, uses = uses }
	},
    on_place = on_place,
    on_secondary_use = on_sec_place,
})

minetest.register_tool("omni_tool:shovel", {
    short_description = "Omni Tool",
    description = "Omni Tool\nShovel",
    inventory_image = "omni_tool_shovel.png",
    groups = { tool=1, shovel=1, dig_speed_class=5, enchantability=10 },
    tool_capabilities = {
        full_punch_interval = 0.83333333,
        max_drop_level = 5,
        punch_attack_uses = uses,
        groupcaps = {
            crumbly = {
                maxlevel = 3,
                uses = uses,
                times = { [1]=1.10, [2]=0.50, [3]=0.30 }
            },
        },
        damage_groups = {fleshy=5},
    },
    sound = { breaks = "default_tool_breaks" },
    _mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 8, level = 5, uses = uses }
	},
    on_place = on_place,
    on_secondary_use = on_sec_place,
})

local pick = "default:pick_diamond"
local axe = "default:axe_diamond"
local shovel = "default:shovel_diamond"
local fuse = "default:mese_crystal"
local air = ""
if minetest.registered_nodes["mcl_core:stone"] ~= nil then
    pick = "mcl_core:pick_diamond"
    axe = "mcl_core:axe_diamond"
    shovel = "mcl_core:shovel_diamond"
    fuse = "mesecons:redstone"
end

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {pick, axe, shovel},
        {air, fuse, air},
        {air, fuse, air}
    }
})

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {axe, pick, shovel},
        {air, fuse, air},
        {air, fuse, air}
    }
})

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {axe, shovel, pick},
        {air, fuse, air},
        {air, fuse, air}
    }
})

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {shovel, axe, pick},
        {air, fuse, air},
        {air, fuse, air}
    }
})

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {shovel, pick, axe},
        {air, fuse, air},
        {air, fuse, air}
    }
})

minetest.register_craft({
    output = "omni_tool:axe",
    recipe = {
        {pick, shovel, axe},
        {air, fuse, air},
        {air, fuse, air}
    }
})
