print("This file will be run at load time!")

minetest.register_privilege("deathback", {
    description = "Can teleport to last death",
    give_to_singleplayer = true
})

minetest.register_chatcommand("back", {
    privs = {
        deathback = true,
    },
	func = function(name)
		local player = minetest.get_player_by_name(name)
		local meta = player:get_meta()
		if meta:get_string("deathbackpos") ~= "returned" then
			player:set_pos(minetest.deserialize(meta:get_string("deathbackpos")))
			meta:set_string("deathbackpos", "returned")
		elseif meta:get_string("deathbackpos") == "returned" then
			minetest.chat_send_player(name, "You have already teleported to your death point!")
		else
			minetest.chat_send_player(name, "You have not died!")
		end
end})

minetest.register_on_dieplayer(function(player)
	local meta = player:get_meta()
	meta:set_string("deathbackpos", minetest.serialize(vector.round(player:get_pos())))
end)