
local S = mobs.intllib

-- Sandwich texture extracted from Sandwiches! mod.
minetest.register_craftitem("mobs_npc:sandwich", {
	description="Sandwich",
	inventory_image="classic_sandwich.png",
	on_use=minetest.item_eat(10),
})

minetest.register_craft {
	type = "shapeless",
	output = "mobs_npc:sandwich",
	recipe = { "farming:bread", "mobs_fish:fried_fish"}
}
-- Npc by TenPlus1

local textures={{"mobs_npc1.png"}, {"mobs_npc2.png"}, {"mobs_npc3.png"}, {"mobs_npc4.png"}, {"mobs_npc5.png"}, {"mobs_npc6.png"}, {"mobs_npc7.png"}, {"mobs_npc8.png"}}
local animation={
		speed_normal = 15,
		speed_run = 15,
		stand_start = 0,
		stand_end = 79,
		walk_start = 168,
		walk_end = 187,
		run_start = 168,
		run_end = 187,
		punch_start = 200,
		punch_end = 219,
	}
local colbox={-0.35,0,-0.35, 0.35,1.8,0.35}

local trades= {
	-- ["mobs_fish:fried_fish"]={'farming:seed_wheat 2'},
	-- ["farming:bread"]={'farming:seed_cotton 2'},
	-- ["default:diamond"]={'wands:invis', 'wands:teleport', 'wands:butterfly', 'wands:water', 'wands:smoke', 'wands:elemental'},
	["default:mese"]={'beacon:beacon'},
	["more_mese:mese_crystal_red"]= {'3d_armor:helmet_greater', '3d_armor:chestplate_greater', '3d_armor:leggings_greater', '3d_armor:boots_greater'},
	["mob_bee:honey_cake"]={'dungeon_crates:crate'},
	["mobs_npc:sandwich"]={'dungeon_crates:crate'},
}

local dialogs= {
"Thanks for your hospitality!",
"It was about time...",
"Why did I come here again? Oh, yeah. to trade garba... I mean stuff!",
"Thanks for your business.",
"Don't ask me where I got this...",
"I hope it will be helpful to you.",
"Don't hurt yourself with that.",
"And that was the last one. I can finally go home.",
"Sry gtg wife calling.",
"Have we met before?",
"I'll come back for sure!",
"Maybe one day, I'll be an honest person...",
"You really live here?",
"I'll recommand your shop!",
"Wow, you scared me.",
"I've heard a weird noise.",
"I love this place!",
"Find me more of this!",
"No offense, but I've been wondering for a while... Are you human?",
"See you!",
"I like you, you know? I kept this one just for you!",
"My friend told me not to go to this dive anymore, but I can't help myself.",
"I am not here to play games.",
"Deal!",
"Someone here told me that she got red mese from a huge red wasp but she did not want to trade it.",
"Good luck!",
"Have a nice day.",
"Fashion is a concept yet to be invented here.",
"Wait! I'll get some more! Just wait here!",
"No, sorry, I cannot take you with me.",
}

local function pick(list) return list[math.random(1, #list)] end

mobs:register_mob("mobs_npc:npc", {
	type = "npc",
	passive = true,
	runaway=true,
	damage = 1,
	attack_type = "dogfight",
	attacks_monsters = false,
	owner_loyal = true,
	hp_min = 10,
	hp_max = 10,
	collisionbox = colbox,
	visual = "mesh",
	mesh = "character.b3d",
	drawtype = "front",
	textures = {
		{"mobs_trader.png"},
		{"mobs_trader2.png"},
		{"mobs_trader3.png"},
		{"mobs_trader_female.png"},
	},
	makes_footstep_sound = true,
	sounds = {},
	--walk_chance=1,
	walk_velocity = 1,
	run_velocity = 1,
	jump = true,
	jump_height=0.01,
	
	lava_damage = 6,
	view_range = 10,
	owner = "",
	order = "follow",
	--fear_height = 3,
	animation = animation,

	on_rightclick = function(self, clicker)

		local item = clicker:get_wielded_item()
		local name = clicker:get_player_name()
		if not item then return end
		local trade=trades[item:get_name()]
		if not trade then 
			minetest.chat_send_player(name, "Not interested.")
			return
		end
		item:take_item()
		local p=self.object:get_pos()
		p.y=p.y+0.5
		minetest.add_item(p, pick(trade))
		clicker:set_wielded_item(item)
		local pos=self.object:get_pos()
		mobs.tp_fx(pos)
		self.object:remove();
		minetest.chat_send_player(name, minetest.colorize("cyan", pick(dialogs)))
	end,

})

mobs:spawn({
	name = "mobs_npc:npc",
	nodes = {"group:cloth"},
	neighbors={"group:furniture"},
	interval=31,
	chance = 400,
	min_height=-10,
	max_height=999,
	min_light=8,
	max_light=14,
})

--[[
mobs:spawn({
	name = "mobs_npc:npc",
	nodes = {"default:mossycobble"},
	neighbors={"group:protected"},
	chance = 4000,
	active_object_count = 2,
	min_height=-10,
	max_height=999,
	min_light=15,
	max_light=15,
})
]]


--mobs:register_egg("mobs_npc:npc", S("Npc"), "default_brick.png", 1)

-- compatibility
--mobs:alias_mob("mobs:npc", "mobs_npc:npc")
