-- Textures taken from un-licenced work of "anonymous_moose":
-- https://forum.minetest.net/viewtopic.php?f=9&t=12703&p=216983&hilit=magic+wands#p216983

local wand_craft= function(crystal, wand)
minetest.register_craft({
	output = wand,
	recipe = {
		{ crystal },
		{ "group:stick" },
		{ "group:stick" },
	} });
end


mobs:register_arrow("wands:missile", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"magic_wand_lightning.png"},
	velocity = 8,
	tail=1,
	tail_texture="magic_wand_lightning.png",
	tail_size=2,
	glow=7,
	expire=0.05,
	ttl=1,

	hit_player = function(self, player)
		-- if player==self.owner_id then return end
		player:punch(self.object, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 2},
		})
	end,

	hit_mob = function(self, player)
		player:punch(self.owner_id, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 2, knockback=1},
		})
	end,

	hit_node = function(self, pos, node)
		self.object:remove()
	end,
})
mobs:register_arrow("wands:missile_confuse", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"magic_wand_lightning.png"},
	velocity = 8,
	tail=1,
	tail_texture="magic_wand_lightning.png",
	tail_size=2,
	glow=7,
	expire=0.05,

	hit_player = function(self, player)
		-- if player==self.owner_id then return end
		player:punch(self.object, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 8},
		})
	end,

	hit_mob = function(self, mob)
		mob:punch(self.owner_id, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 1},
		})
		mobs.attack_monster(mob)
	end,

	hit_node = function(self, pos, node)
		self.object:remove()
	end,
})

--[[
minetest.register_tool("wands:smoke", {
	description = "Healing Wand\nFull heal\nPoint-blank.\n~30 uses.",
	inventory_image = "plant_wand.png",
	sound = {breaks = "default_tool_breaks"},
	groups={not_repaired_by_anvil=1},
	tool_capabilities = {
		full_punch_interval = 0.01,
	},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		player:set_hp(20)
		minetest.sound_play("mobs_spell", {pos=player:get_pos(), gain=0.5, max_hear_distance=16}, true)
		itemstack:add_wear(65536/32)
		return itemstack
	end
})
]]

--[[
minetest.register_craft({
	output = "wands:basic",
	recipe = {
		{ "default:mese_crystal" },
		{ "default:gold_ingot" },
		{ "default:stick" },
	} });
	--]]

-- MESE WAND
--[[
mobs:register_arrow("wands:mese_missile", {
	visual = "sprite",
	visual_size = {x = 0.2, y = 0.2},
	textures = {"magic_wand_lightning.png"},
	velocity = 10,
	tail=1,
	tail_texture="magic_wand_lightning.png",
	tail_size=2,
	glow=3,
	expire=0.05,

	hit_player = function(self, player)
		splash(self)
	end,

	hit_mob = function(self, player)
		splash(self)
	end,

	hit_node = function(self, pos, node)
		self.object:remove() -- mobs:boom(self, pos, 1)
	end,
	-- on_activate=function(self) self.timer=60 end
})
--]]
minetest.register_tool("wands:mese", {
	description = "Mese Wand\n2 damage/short range/~500 uses.",
	inventory_image = "lightning_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-1
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 14))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
		itemstack:add_wear(65536/512)
		return itemstack
	end
})

wand_craft("default:mese_crystal", "wands:mese")

minetest.register_tool("wands:mese_sup", {
	description = "Confusion wand\nTarget attacks the closest monster to itself (~130 uses).",
	inventory_image = "nyan_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<2 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-2
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:missile_confuse")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 18))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
		itemstack:add_wear(65536/128)
		return itemstack
	end
})

wand_craft("more_mese:mese_crystal_orange", "wands:mese_sup")

-- BLAST WAND
mobs:register_arrow("wands:explosive_missile", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"horror_flame3.png"},
	glow=10,
	velocity = 6,
	tail = 1, -- enable tail
	tail_texture = "horror_flame2.png",

	hit_player = function(self, player)
		mobs:explosion(player:get_pos(), 2)
	end,

	hit_mob = function(self, player)
		mobs:explosion(player:get_pos(), 2)
	end,

	hit_node = function(self, pos, node)
		mobs:explosion(pos, 2)
	end,
})
mobs:register_arrow("wands:confusion", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"horror_shadow.png"},
	velocity = 8,
	tail=1,
	tail_texture="horror_shadow.png",
	tail_size=2,
	expire=0.05,
	ttl=1,

	hit_player = function(self, player)
		-- Hopefully restores 40HP, that is full health and mana. TODO test it.
		player:punch(self.object, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = -40},
		})
	end,

	hit_mob = function(self, ent)
		local mob=ent:get_luaentity()
		if mob and mob.type=="monster" then
			mob.type="npc"
			mob.regen=-0.1
			mob.state="stand"
			mob.attacks_monsters=true
		end
	end,

	hit_node = function(self, pos)
		local p=minetest.find_node_near(self.lastpos or pos,1, {"air"}, true)
		if p then
			-- player probably missed. Don't let the shot entirely go to waste
			minetest.env:add_entity(p, "mob_shadow:shadow")
		end
	end,
})
minetest.register_tool("wands:blast", {
	description = "Confusion Wand.\nTurn a foe into an ally.\nShort range.\n~30 uses.",
	inventory_image = "fire_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<5 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-5
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:confusion")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 14))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
		itemstack:add_wear(65536/32)
		return itemstack
		--[[
		if player:get_attach() then return end
		local pos=player:get_pos()
		pos.y=pos.y+0.5
		minetest.add_entity(pos, "mob_wasp:wasp_ally")
		minetest.sound_play("tnt_ignite", {pos=pos, gain=0.5, max_hear_distance=16}, true)
		itemstack:add_wear(65536/64)
		return itemstack
		]]

	end
})

--[[
minetest.register_craft({
	output = "wands:blast",
	recipe = {
		{ "", "more_mese:mese_crystal_red", "" },
		{ "", "group:stick", ""},
		{ "", "group:stick", "" },
	} });
]]
-- Gravity WAND
--[[
mobs:register_arrow("wands:grav_missile", {
	visual = "sprite",
	visual_size = {x = 0.2, y = 0.2},
	textures = {"horror_flame3.png"},
	velocity = 1,
	tail=1,
	tail_texture="horror_flame3.png",
	tail_size=1,
	glow=7,
	expire=0.05,

--	hit_player = function(self, player)
--		if player==self.owner_id then return end
--		player:punch(self.owner_id, 1.0, {
--			full_punch_interval = 0.1,
--			damage_groups = {fleshy = 1, knockback=10},
--		}, nil)
--	end,
--
--	hit_mob = function(self, player)
--		player:punch(self.owner_id, 1.0, {
--			full_punch_interval = 0.1,
--			damage_groups = {fleshy = 1, knockback=10},
--		}, nil)
	on_step=function(self, dtime)
		local p=self.object:get_pos()
		local objs=minetest.get_objects_inside_radius(p, 5)
		for n=1, #objs do
			local obj=objs[n]
			if not obj:is_player() and obj~=self.object then
				local v=vector.normalize(vector.subtract(p, obj:get_pos()))
				obj:set_velocity(v)
			end
		end

	end,

	hit_node = function(self, pos, node)
		self.object:remove() -- mobs:boom(self, pos, 1)
	end,
	--on_activate=function(self) self.object:set_velocity {x=0, y=0, z=0} end
})

minetest.register_tool("wands:gravity", {
	description = "Gravity Wand\nCreates an energy ball that attracts nearby mobs\nEnergy/shot: 3\nUses: ~30",
	inventory_image = "bubble_wand.png",
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<3 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-3
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:grav_missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 1))
		minetest.sound_play("tnt_ignite", {object=obj, max_hear_distance=16}, true)
		itemstack:add_wear(65536/32)
		return itemstack
	end
})

minetest.register_craft({
	output = "wands:gravity",
	recipe = {
		{ "default:mese_crystal" },
		{ "default:steel_ingot" },
		{ "default:stick" },
	} });
--]]
--[[
local cleanMese=function(pos)
	while true do
		local p=minetest.find_node_near(pos, 2, {"minefall_core:melding"}, true)
		if not p then return end
		minetest.swap_node(p, {name="air"})
	end
end

mobs:register_arrow("wands:am_missile", {
	visual = "sprite",
	visual_size = {x = 0.2, y = 0.2},
	textures = {"horror_flame3.png"},
	velocity = 1,
	tail=1,
	tail_texture="horror_flame3.png",
	tail_size=1,
	glow=7,
	expire=0.05,

	hit_player = function(self, player)
		if player==self.owner_id then return end
		cleanMese(player:get_pos())
	end,

	hit_mob = function(self, player)
		cleanMese(player:get_pos())
	end,
	hit_node = function(self, pos, node)
		cleanMese(pos)
	end,
})
--]]
--[[
minetest.register_tool("wands:stingy", {
	description = "Stingy Wand\nClears melding at point of impact\nEnergy required: 0.1\nUses: ~15",
	inventory_image = "bubble_wand.png",
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<0.1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-0.1
		local phy=player:get_physics_override()
		phy.gravity=-0.5
		player:set_physics_override(phy)
		minetest.after(1, function(p)
			--if player:get_player_name(p)=="" then return end
			local phy=player:get_physics_override()
			phy.gravity=1
			player:set_physics_override(phy)
		end,
		player)

		itemstack:add_wear(65536/16)
		return itemstack
	end
})


minetest.register_craft({
	output = "wands:stingy",
	recipe = {
		{ "default:mese_crystal" },
		{ "mob_wasp:wasp" },
		{ "default:stick" },
	} });
	--]]
-- BUTTERFLY WAND

--[[
function put_light_near(pos)
	local p=minetest.find_node_near(pos, 1, {"air"}, true)
	if p then minetest.set_node(p, {name="mobs_butterfly:lit_air"}) end
end
--]]


minetest.register_node("wands:lit_water", {
	description = "Magically lit water Source",
	drawtype = "airlike",
	--[[
	tiles = {
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	]]
	use_texture_alpha="clip",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	liquidtype = "node",
	liquid_viscosity = 1,
	liquid_renewable=false,
	post_effect_color = {a = 103, r = 30, g = 60, b = 90},
	groups = {igniter=1},
	sounds = default.node_sound_water_defaults(),
	light_source=14,
	on_construct=function(pos)
		local timer=minetest.get_node_timer(pos)
		timer:start(60)
	end,

	on_timer=function(pos)
		-- could replace with water_source, but air is safer in case of a bug
		minetest.swap_node(pos, {name="air"})
	end,
	damage_per_second=2,

})

--[[
local splash=function(self)
	local p=self.object:get_pos()
	local objs=minetest.get_objects_inside_radius(p, 3)
	for n=1, #objs do
		local obj=objs[n]
		obj:punch(self.owner_id, 1.0, {
			full_punch_interval=0.1,
			damage_groups={fleshy=4},
		}, nil)
	end

end
]]

mobs:register_arrow("wands:butterfly_missile", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"magic_wand_noogberry_orange.png"},
	velocity = 8,
	tail=1,
	tail_texture="magic_wand_noogberry_orange.png",
	tail_size=2,
	glow=7,
	expire=0.05,

	hit_player = function(self, player)
		player:punch(self.object, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 8},
		})
	end,

	hit_mob = function(self, mob)
		-- local e=mob:get_luaentity()
		-- e.view_range=15
		mob:punch(self.object, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 8, knockback=5},
		})
	end,

	hit_node = function(self, pos, node)
		local target=minetest.find_node_near(self.lastpos or pos, 1, {"default:water_source", "air"}, true)
		if target then
			minetest.set_node(target, {name="wands:lit_water"})
			return
		end
		--[[
		local target=minetest.find_node_near(pos, 1, "air", true)
		if target then
			minetest.set_node(target, {name="fire:basic_flame"})
			return
		end
		]]
	end,
})

--[[
minetest.register_tool("wands:butterfly", {
	description = "Flame Wand (restricted).\nCreates a light orb near impact. Can ignite things.\nMobs: 5s stun.\nLong range.\n~130 uses.",
	inventory_image = "nyan_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if bones.get_mode_for(player) ~= "drop" then return itemstack end
		if mfplayers[name].energy<5 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-5
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:butterfly_missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 14))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.5, max_hear_distance=16}, true)
		itemstack:add_wear(65536/128)
		return itemstack
	end
})
]]
-- No receipe, loot item.

-- Teleportation WAND

local vero={x=0, y=0, z=0}

mobs:register_arrow("wands:teleport_missile", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"magic_wand_noogberry.png"},
	velocity = 8,
	tail=1,
	tail_texture="magic_wand_noogberry.png",
	tail_size=2,
	glow=7,
	expire=0.05,

	hit_player = function(self, player)
		if player==self.owner_id or not self.owner_id then return end
		local target=player:get_pos()
		local owner=self.owner_id:get_pos()
		if target and owner then
			self.owner_id:set_velocity(vero)
			self.owner_id:move_to(target, true)
			player:move_to(owner, true)
			minetest.sound_play("nether_portal_teleport", {pos=target, max_hear_distance=16}, true)
		end
	end,

	hit_mob = function(self, player)
		if not self.owner_id then return end
		local target=player:get_pos()
		local owner=self.owner_id:get_pos()
		if target and owner then
			self.owner_id:set_velocity(vero)
			self.owner_id:move_to(target, true)
			owner.y=owner.y-player:get_properties().collisionbox[2]
			player:move_to(owner, true)
			player:set_velocity(vero)
			local mob=player:get_luaentity()
			mob.state="stand"
			mob.pause_timer=3 -- 3 secs stun
			minetest.sound_play("nether_portal_teleport", {pos=target, max_hear_distance=16}, true)
		end
	end,

	hit_node = function(self, pos, node)
		--if node.name=="ignore" then return end
		local target=minetest.find_node_near(self.lastpos or pos, 1, { "air", "group:liquid" }, true)
		if target then
			local owner=self.owner_id
			if owner then
				owner:set_velocity(vero)
				owner:move_to(target, true)
				minetest.sound_play("nether_portal_teleport", {pos=target, max_hear_distance=16}, true)
			end
		end

		self.object:remove()
	end,
})


minetest.register_tool("wands:teleport", {
	description = "Teleportation Wand\nTeleports you at point of impact or swaps places with mob or player.\nLong range.\n~130 uses.",
	inventory_image = "stone_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-1
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:teleport_missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 18))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
		itemstack:add_wear(65536/128)
		return itemstack
	end
})

wand_craft("more_mese:mese_crystal_grey", "wands:teleport")

--[[
minetest.register_craft({
	output = "wands:teleport",
	recipe = {
		{ "default:mese_crystal" },
		{ "default:diamond" },
		{ "default:stick" },
	} });
	]]


local freeze=function(impact)
	local p1={x=impact.x-1, y=impact.y-1, z=impact.z-1}
	local p2={x=impact.x+1, y=impact.y+1, z=impact.z+1}
	for _, p in ipairs(minetest.find_nodes_in_area(p1, p2,"air")) do
		if not minetest.is_protected(p) then
			minetest.set_node(p, {name="default:ice"})
			minetest.get_node_timer(p):start(math.random(4,6))
		end
	end
	for _, p in ipairs(minetest.find_nodes_in_area(p1, p2,{"default:water_source", "default:river_water_source"})) do
		if not minetest.is_protected(p) then
			minetest.set_node(p, {name="default:ice"})
		end
	end
end


mobs:register_arrow("wands:ice_missile", {
	visual = "sprite",
	visual_size = {x = 0.2, y = 0.2},
	textures = {"default_snowball.png"},
	velocity = 10,
	tail=1,
	tail_texture="default_snowball.png",
	tail_size=2,
	glow=7,
	expire=0.05,
	ttl=1,

	hit_player = function(self, player)
		freeze(player:get_pos())
	end,

	hit_mob = function(self, player)
		freeze(player:get_pos())
	end,

	hit_node = function(self, pos, node)
		freeze(self.lastpos or pos)
	end,
	-- on_activate=function(self) self.timer=60 end
})

minetest.register_tool("wands:water", {
	description = "Ice Wand.\nFreezes air and water at point of impact.\nShort range.\n~130 uses.",
	inventory_image = "ice_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-1
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:ice_missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 14))
		minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
		itemstack:add_wear(65536/128)
		return itemstack
	end
})

wand_craft("more_mese:mese_crystal_cyan", "wands:water")

--[[
minetest.register_tool("wands:invis", {
	description = "Ghost Wand\nSummons a short-lived ally.\nPoint-blank.\n~250 uses.",
	inventory_image = "stone_wand.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		-- We have to add wear before and exit if the wand breaks
		-- because otherwise the player will punch the Shadow.
		itemstack:add_wear(65536/256)
		if itemstack:get_count()==0 then return itemstack end
		local name=player:get_player_name()
		if mfplayers[name].energy<1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-1
		local pos=player:get_pos()
		minetest.add_entity(pos, "mob_shadow:shadow")
		minetest.sound_play("tnt_ignite", {pos=pos, gain=0.5, max_hear_distance=16}, true)
		return itemstack
	end
})
--[[
minetest.register_craft({
	output = "wands:invis",
	recipe = {
		{ "default:mese_crystal" },
		{ "default:steelblock" },
		{ "default:stick" },
	} });
]]


--[[
minetest.register_tool("wands:metal", {
	description = "Ore detection wand",
	inventory_image = "stone_wand.png",
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		local zero={x=0, y=0, z=0}
		local pos=player:get_pos()
		local vol=5
		local p1={x=pos.x-vol, y=pos.y-vol, z=pos.z-vol}
		local p2={x=pos.x+vol, y=pos.y+vol, z=pos.z+vol}
		for _,ore in ipairs(minetest.find_nodes_in_area(p1, p2, {"group:ore"})) do
			minetest.add_particlespawner
			{
				amount=200,
				time=20,
				minpos=ore,
				maxpos=ore,
				minvel={x=-5,y=-5,z=-5},
				maxvel={x=5,y=5,z=5},
				minacc=zero,
				maxacc=zero,
				minsize=4,
				maxsize=4,
				texture="default_mineral_mese.png",
				playername=player:get_player_name()
			}
		end
		itemstack:add_wear(65536/128)
		return itemstack
	end
})

minetest.register_craft({
	output = "wands:metal",
	recipe = {
		{ "default:mese_crystal_fragment" },
		{ "default:tin_lump" },
		{ "default:stick" },
	} });
--]]
--[[
minetest.register_tool("wands:mana", {
	description = "Mana Wand\nRestores full mana. ~250 uses.",
	inventory_image = "plant_wand.png",
	sound = {breaks = "default_tool_breaks"},
	on_use=function(itemstack, player)
		local name=player:get_player_name()
		mfplayers[name].energy=mfplayers[name].max_energy
		hb.change_hudbar(player,"energy", mfplayers[name].energy)
		itemstack:add_wear(65536/256)
		return itemstack
	end
})
minetest.register_craft({
	output = "wands:mana",
	recipe = {
		{ "default:mese" },
		{ "default:mese" },
		{ "default:stick" },
	} });
--]]

-- FLINT STONE THROWING (not a wand)
--[[
mobs:register_arrow("wands:flint_missile", {
	visual = "sprite",
	visual_size = {x = 0.1, y = 0.1},
	textures = {"default_flint.png"},
	velocity = 8,
	expire=0.05,
	ttl=1,

	hit_player = function(self, player)
		-- if player==self.owner_id then return end
		player:punch(self.owner_id, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 1},
		}, nil)
	end,

	hit_mob = function(self, player)
		player:punch(self.owner_id, 1.0, {
			full_punch_interval = 0.1,
			damage_groups = {fleshy = 1, knockback=0.1},
		}, nil)
	end,

	hit_node = function(self, pos, node)
		self.object:remove()
	end,
})

minetest.override_item("default:flint", {
	on_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<0.5 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-0.5
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:flint_missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 13))
		itemstack:take_item(1)
		return itemstack
	end})


	--]]
-- PROTECTION CHECK

--[[
minetest.override_item("more_mese:mese_crystal_fragment_grey", {
	on_use=function(itemstack, player, pointed_thing)
		if player:get_attach() then return end
		if not pointed_thing then return end
		if pointed_thing.type ~="node" then return end
		local pos=pointed_thing.under
		if not minetest.is_protected(pos) then return itemstack end

		local protector=minetest.find_node_near(pos, 1, {"group:protected"}, true)
		local name=player:get_player_name()
		if protector and minetest.get_meta(protector):get_string("owner")==name then
			minetest.sound_play("default_dig_metal", {pos=pos, gain=1, max_hear_distance=8}, true)
			minetest.chat_send_player(name, "Protected.")
		end
		return itemstack
	end
})
]]

elements=minetest.get_mod_storage()
local ecache={}

minetest.register_chatcommand("focus", {
	description="Choose a Focus",
	params="<focus nane>",
	func=function(name, param)
		local player=minetest.get_player_by_name(name)
		if not player then return end
		local bmode=bones.get_mode_for(player)
		local element=ecache[name] or elements:get_string(name)
		ecache[name]=element
		if param=="" then
			minetest.chat_send_player(name, "Choose or change an effect for the green wand, and become a Regular player. Costs 20 RP.\n Focuses are:\n- air: changes a monster into a whale.\n- light: creates a light orb on hit, can ignite flammable blocks.\n- shadow: summons an ally.")
			if element ~= "" then
				minetest.chat_send_player(name, "Your current focus is: ".. element)
			end
			return true
		end
		local valid={air=true, light=true, shadow=true}
		if not valid[param] then
			minetest.chat_send_player(name, "this is not a valid focus name")
			return true
		end
		if rp.get_player_count(name) > 20 then
			rp.award(name, -20, false)
		else
			minetest.chat_send_player(name, "You need 20 RP for this")
			return true
		end
		elements:set_string(name, param)
		if bmode=="keep" and (element=="") then
			minetest.chat_send_all(minetest.colorize("green", name.." became a Regular player!"))
			bones.set_mode_for(player, "bones")
		end
		minetest.chat_send_player(name, "Your focus is now: "..param)
		ecache[name]=param
		return true
	end
})

mobs:register_arrow("wands:whale_missile", {
	visual = "sprite",
	visual_size = {x = 0.2, y = 0.2},
	textures = {"default_snowball.png"},
	velocity = 10,
	tail=1,
	tail_texture="default_snowball.png",
	tail_size=2,
	glow=7,
	expire=0.05,
	ttl=1,

	hit_mob = function(self, player)
		local mob=player:get_luaentity()
		if mob and mob.type=="monster" then
			minetest.add_entity(player:get_pos(), "mob_whale:whale")
			player:remove()
		end
	end,

})

minetest.register_tool("wands:focus", {
	description = "Focus Wand\n~130 uses\nEffect depends on the Focus you select (see /focus)",
	inventory_image = "plant_wand.png",
	sound = {breaks = "default_tool_breaks"},
	groups={not_repaired_by_anvil=1},
	tool_capabilities = {
		full_punch_interval = 0.01,
	},
	on_use=function(itemstack, player)
		if player:get_attach() then
			return itemstack
		end
		local name=player:get_player_name()
		local element=ecache[name] or elements:get_string(name)
		ecache[name]=element
		if element == "" then
			return itemstack
		end
		if mfplayers[name].energy<2 then
			return itemstack
		end
		mfplayers[name].energy=mfplayers[name].energy-2
		local p=player:get_pos()
		if element=="air" then
			p.y=p.y+1.6
			local look_dir=player:get_look_dir()
			local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:whale_missile")
			local ent=obj:get_luaentity()
			ent.owner_id=player
			ent.switch=1
			obj:set_velocity(vector.multiply(look_dir, 14))
			minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
			itemstack:add_wear(65536/128)
			return itemstack
		end
		if element=="light" then
			p.y=p.y+1.6
			local look_dir=player:get_look_dir()
			local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:butterfly_missile")
			local ent=obj:get_luaentity()
			ent.owner_id=player
			ent.switch=1
			obj:set_velocity(vector.multiply(look_dir, 14))
			minetest.sound_play("mobs_spell", {object=obj, gain=0.25, max_hear_distance=16}, true)
			itemstack:add_wear(65536/128)
			return itemstack
		end
		if element=="shadow" then
			-- We have to add wear before and exit if the wand breaks because otherwise the player will punch the Shadow.
			itemstack:add_wear(65536/128)
			if itemstack:get_count()==0 then return itemstack end
			minetest.add_entity(p, "mob_shadow:shadow")
			minetest.sound_play("tnt_ignite", {pos=p, gain=0.5, max_hear_distance=16}, true)
			return itemstack
		end
	end
})

wand_craft("more_mese:mese_crystal_green", "wands:focus")

--[[
minetest.register_craft({
	output = "wands:detector",
	recipe = {
		{ "default:mese_shard" },
		{ "default:steel_ingot" },
		{ "default:stick" },
	} });
--]]

--[[
local function shoot(itemstack, player)
	local name=player:get_player_name()
	if mfplayers[name].energy<3 then return nil end
	mfplayers[name].energy=mfplayers[name].energy-3
	local p=player:get_pos()
	p.y=p.y+1.6
	local look_dir=player:get_look_dir()
	local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:teleport_missile")
	local ent=obj:get_luaentity()
	ent.owner_id=player
	ent.switch=1
	ent.ttl=1
	obj:set_velocity(vector.multiply(look_dir, 12))
	minetest.sound_play("mobs_spell", {object=obj, max_hear_distance=16})
	itemstack:add_wear(65536/128)
	return itemstack
end
--]]

--[[
local detect=function(itemstack, player)
	local name=player:get_player_name()
	if mfplayers[name].energy<1 then return nil end
	mfplayers[name].energy=mfplayers[name].energy-1
	local zero={x=0, y=0, z=0}
	local pos=player:get_pos()
	local vol=5
	local p1={x=pos.x-vol, y=pos.y-vol, z=pos.z-vol}
	local p2={x=pos.x+vol, y=pos.y+vol, z=pos.z+vol}
	local ores=(itemstack:get_name()=="default:sword_steel" and "group:ore") or "default:stone_with_tin"
	for _,ore in ipairs(minetest.find_nodes_in_area(p1, p2, {ores})) do
		minetest.add_particlespawner
		{
			amount=200,
			time=20,
			minpos=ore,
			maxpos=ore,
			minvel={x=-5,y=-5,z=-5},
			maxvel={x=5,y=5,z=5},
			minacc=zero,
			maxacc=zero,
			minsize=4,
			maxsize=4,
			texture="default_mineral_mese.png",
			playername=player:get_player_name()
		}
	end
	itemstack:add_wear(65536/64)
	return itemstack
end

minetest.override_item("default:sword_bronze", { on_secondary_use=detect })
minetest.override_item("default:sword_steel", { on_secondary_use=detect })
minetest.register_tool("wands:sword", {
	description = "Mese Sword",
	inventory_image = "default_tool_mesesword.png",
	groups={not_repaired_by_anvil=1},
	sound = {breaks = "default_tool_breaks"},
	tool_capabilities = {
		full_punch_interval = 0.7,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.5, [2]=1.20, [3]=0.35}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 256,
	},

	on_secondary_use=function(itemstack, player)
		if player:get_attach() then return end
		local name=player:get_player_name()
		if mfplayers[name].energy<1 then return nil end
		mfplayers[name].energy=mfplayers[name].energy-1
		local p=player:get_pos()
		p.y=p.y+1.6
		local look_dir=player:get_look_dir()
		local obj=minetest.add_entity(vector.add(p, vector.multiply(look_dir,1)), "wands:missile")
		local ent=obj:get_luaentity()
		ent.owner_id=player
		ent.switch=1
		obj:set_velocity(vector.multiply(look_dir, 18))
		minetest.sound_play("mobs_spell", {object=obj, max_hear_distance=16}, true)
		itemstack:add_wear(65536/512)
		return itemstack
	end
})
]]

minetest.register_craftitem("wands:scroll_return", {
	description = "Scroll of Return. Teleports to your waypoint and set your waypoint to your previous location.",
	inventory_image = "default_sign_wood.png^[transformR90",
	groups = {flammable = 3},
	on_use= function(itemstack, player)
		--[[
		local objs = minetest.get_objects_inside_radius(player:get_pos(), 10)

		for n = 1, #objs do
			local obj = objs[n]:get_luaentity()
			if obj then
				-- only alert members of same mob
				if obj.type=="monster" then
					objs[n]:punch(player, 1,
						{
							full_punch_interval=0.1,
							damage_groups={fleshy=1, knockback=50}
						})
				end
			end
		end
		]]
		local name=player:get_player_name()
		local pw=compass.get_wp2(name)
		if not pw then
			minetest.chat_send_player(name, minetest.colorize("orange", "Your waypoint is not set"))
			return itemstack
		end
		pw.y=pw.y+1
		compass.set_wp2(name, player:get_pos())
		player:set_pos(pw)
		minetest.sound_play("nether_portal_teleport", {pos=pw, max_hear_distance=16}, true)
		itemstack:take_item()
		return itemstack
	end
})
