--[[

  Nether mod for minetest

  Copyright (C) 2013 PilzAdam

  Permission to use, copy, modify, and/or distribute this software for
  any purpose with or without fee is hereby granted, provided that the
  above copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
  WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR
  BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
  OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
  SOFTWARE.

]]--

local S = abyss.get_translator

-- Portal/wormhole nodes

abyss.register_wormhole_node("abyss:portal", {
	description = S("Nether Portal"),
	post_effect_color = {
		-- post_effect_color can't be changed dynamically in Minetest like the portal colour is.
		-- If you need a different post_effect_color then use register_wormhole_node to create
		-- another wormhole node and set it as the wormhole_node_name in your portaldef.
		-- Hopefully this colour is close enough to magenta to work with the traditional magenta
		-- portals, close enough to red to work for a red portal, and also close enough to red to
		-- work with blue & cyan portals - since blue portals are sometimes portrayed as being red
		-- from the opposite side / from the inside.
		a = 160, r = 128, g = 0, b = 80
	},
	drowning=1,
})

local portal_animation2 = {
	name = "nether_portal.png",
	animation = {
		type = "vertical_frames",
		aspect_w = 16,
		aspect_h = 16,
		length = 0.5,
	},
}

abyss.register_wormhole_node("abyss:portal_alt", {
	description = S("Portal"),
	tiles = {
		"nether_transparent.png",
		"nether_transparent.png",
		"nether_transparent.png",
		"nether_transparent.png",
		portal_animation2,
		portal_animation2
	},
	post_effect_color = {
		-- hopefully blue enough to work with blue portals, and green enough to
		-- work with cyan portals.
		a = 120, r = 0, g = 128, b = 188
	},
	drowning=1,
})

-- Nether nodes

minetest.register_node("abyss:rack", {
	description = S("Abyssite"),
	tiles = {"tms_amazonite.png^[transformR90"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
	light_source=1,
	drop="stairs:stair_abyss_cobble",
})

for _, model in ipairs
	{
		"default:copperblock",
		"default:tinblock",
		"default:bronzeblock",
		"default:steelblock",
		"default:goldblock",
	}
	do
	local name=string.gsub(model, ":", "_")
	minetest.register_node("abyss:mimic_"..name,
	{
		description="Mimic block (active)", -- should not appear in inventory, though.
		tiles=minetest.registered_nodes[model].tiles,
		-- keep the properties of abyss:brick; we do want to let players know it is fake.
		groups={ cracky=2, protected=1},
		sounds = default.node_sound_stone_defaults(),
		drop="abyss:brick",
	})
end
	
minetest.register_node("abyss:brick", {
	description = S("Abyss dungeon brick"),
	tiles = {"nether_brick_deep.png"},
	is_ground_content = true,
	groups = {cracky = 2, level = 1},
	sounds = default.node_sound_stone_defaults(),
	on_place=function(itemstack, placer, pointed)
		if not placer then return nil end
		if pointed.type=="node" then
			local model=minetest.get_node(pointed.under).name
			local mimic="abyss:mimic_"..model.gsub(model, ":", "_")
			local place
			if minetest.registered_nodes[mimic] then
				place=mimic
			elseif string.match(model, "^abyss:mimic_") then
				place=model
			else
				minetest.set_node(pointed.above, {name="abyss:brick"})
			end
			minetest.set_node(pointed.above, {name=place or "abyss:brick"})
			itemstack:take_item(1)
			local owner=placer:get_player_name() 
			if place and owner then
				local meta=minetest.get_meta(pointed.above)
				meta:set_string("owner", owner)
				meta:set_string("infotext", "Owned by "..owner)
			end
			return itemstack
		end
		return nil
	end
})
-- for ruins
minetest.register_node("abyss:abyssite_brick", {
	description = S("Abyss Stone brick"),
	tiles = {"tms_amazonite_brick.png"},
	is_ground_content = true,
	groups = {cracky = 1, stone=1, level=4, noblast=1},
	sounds = default.node_sound_stone_defaults(),
})

-- Deep Netherrack, converted to abyssite cobble
minetest.register_node("abyss:cobble", {
	description = S("Abyssite cobble"),
	tiles = {"tms_amazonite_cobble.png"},
	is_ground_content = true,
	groups = {cracky = 2, level = 1},
	sounds = default.node_sound_stone_defaults(),
	drop="stairs:stair_abyss_cobble 4",
})

--[[
minetest.register_node("abyss:glowstone_off", {
	description = S("Glowstone"),
	tiles = {"nether_glowstone_deep.png"},
	is_ground_content = true,
	paramtype = "light",
	groups = {cracky = 1, level=2},
	sounds = default.node_sound_glass_defaults(),
	on_place=function(itemstack, placer, pointed)
		if not placer then return nil end
		if not pointed.type=="node" then return nil end
		local place
		if pointed.above.y<-5000 then
			place="abyss:glowstone"
		else
			place="abyss:glowstone_off"
		end
		minetest.set_node(pointed.above, {name=place})
		itemstack:take_item(1)
		return itemstack
	end,
})
]]

minetest.register_node("abyss:glowstone", {
	description = S("Glowstone"),
	tiles = {"nether_glowstone_deep.png"},
	is_ground_content = true,
	light_source = 10,
	paramtype = "light",
	groups = {cracky = 3},
	sounds = default.node_sound_glass_defaults(),
	drop="",
})

stairs.register_stair(
	"abyss_cobble",
	"abyss:cobble",
	{cracky = 2, level = 2},
	{"nether_rack_deep.png"},
	S("Abyssite cobble stair"),
	minetest.registered_nodes["abyss:cobble"].sounds
)
