-- Author: Astrobe
-- licence (code): CC-BY-SA 4.0
-- Texture from Xdecor, WTFPL license
-- Version 1.0 

-- Derived from "Dungeon Loot" by BlockMen.

dungeon_crates={loot={"dungeon_crates:crate", "air"}}

minetest.register_node("dungeon_crates:crate", {
	description = "Loot box\nPlacing one grants 1RP.\nDigging one costs 1RP or a mese crystal fragment (punch with a fragment in hand).",
	---tiles = {"default_furnace_bottom.png"},
	-- tiles = {"default_diamond_block.png"},
	tiles = { "xdecor_stone_rune.png" },
	-- tiles = { "bones_front.png" },
	--[[
	tiles = {
		"default_chest_top.png",
		"default_chest_top.png",
		"default_chest_side.png",
		"default_chest_side.png",
		"default_chest_lock.png",
		"default_chest_side.png"
	},
	--]]
	is_ground_content = false,
	groups = {choppy=2, nopicker=1, noblast=1 },
	sounds = default.node_sound_defaults(),
	drop = {
		max_items = 1,
		items = {
			{items = {'3d_armor:mask_cat'}, rarity = 250},
			{items = {'3d_armor:devil'}, rarity = 250},
			{items = {'mob_cats:kitten_set'}, rarity = 200},
			--[[
			{items = {'beacon:beacon'}, rarity = 120},
			{items = {'wands:mese'}, rarity = 20},
			{items = {'default:shovel_bronze'}, rarity = 20},
			{items = {'default:pick_bronze'}, rarity = 10},
			{items = {'default:axe_bronze'}, rarity = 10},
			{items = {'default:sword_bronze'}, rarity = 10},
			]]
			{items = {'default:bronze_ingot 4'}, rarity = 3},
			{items = {'compass:compass 33'}, rarity = 3},
			{items = {'craft_table:simple'}, rarity = 1},
		}
	},
	-- light_source = 2,
})


local function place_spawner(tab)
	local n= #tab
	if tab == nil then return end
	for i=1, n do
		local pos = tab[i]
		pos.y = pos.y - 1
		local below = minetest.get_node_or_nil(pos)
		if below and below.name ~= "air" then
			pos.y = pos.y + 1
			minetest.set_node(pos, {name = dungeon_crates.loot[math.random(1, #dungeon_crates.loot)]})
		end
	end
	local t=tab[math.random(1, #tab)]
	local here=minetest.get_node_or_nil(t)
	if here and here.name~="air" then
		minetest.set_node(t, {name="anchorstone:anchorstone"});	
	end
end

minetest.set_gen_notify("dungeon")
minetest.register_on_generated(function(minp, maxp, blockseed)
	local ntf = minetest.get_mapgen_object("gennotify")
	if ntf and ntf.dungeon then
		minetest.after(0.5, place_spawner, table.copy(ntf.dungeon))
	end
end)

