minetest.register_node("melding:node",
{
	description = "Melding block",
	tiles = {
		{
			name = "nether_portal.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 6,
			},
		},
	},
	drawtype = "glasslike",
	groups={nopicker=1},
	paramtype = "light",
	paramtype2 = "colorfacedir",
	palette = "nether_portals_palette.png",
	post_effect_color = { a = 160, r = 128, g = 0, b = 80 },
	sunlight_propagates = true,
	use_texture_alpha = "blend",
	walkable = false,
	diggable = false,
	pointable = false,
	buildable_to = false,
	drowning=2,
	move_resistance=1,
	light_source=1,
	is_ground_content = false,
	drop = "",
})

-- Here is our good old friend, miss ABM.
minetest.register_abm{
	label="melding expension",
	nodenames="melding:node",
	neighbors= "air",
	interval=1801,
	chance=2,
	catch_up=true,
	action=function(pos)
		--  This works well for us because find_node-near looks at the node right above first
		--  and we prefer an expand-up first behaviour.
		local p=minetest.find_node_near(pos, 1, {name="air"})
		if not p then return end
		if not minetest.is_protected(p) then
			minetest.swap_node(p, {name="melding:node"})
		end
	end,
}
