-- mods/default/crafting.lua

minetest.register_craft({
	output = 'default:wood 4',
	recipe = {
		{'default:tree'},
	}
})

minetest.register_craft({
	output = 'default:junglewood 4',
	recipe = {
		{'default:jungletree'},
	}
})

minetest.register_craft({
	output = 'default:pine_wood 4',
	recipe = {
		{'default:pine_tree'},
	}
})

minetest.register_craft({
	output = 'default:acacia_wood 4',
	recipe = {
		{'default:acacia_tree'},
	}
})

minetest.register_craft({
	output = 'default:aspen_wood 4',
	recipe = {
		{'default:aspen_tree'},
	}
})


--[[
minetest.register_craft({
	output = 'default:stick 2',
	recipe = {
		{'default:bush_stem'},
	}
})

minetest.register_craft({
	output = 'default:stick 2',
	recipe = {
		{'default:acacia_bush_stem'},
	}
})

minetest.register_craft({
	output = "default:stick 2",
	recipe = {
		{"default:pine_bush_stem"},
	}
})

minetest.register_craft({
	output = "default:stick 2",
	recipe = {
		{"default:papyrus"},
	}
})

minetest.register_craft({
	output = "default:stick 2",
	recipe = {
		{"default:cactus"},
	}
})
]]


minetest.register_craft({
	output = 'default:palm_wood 4',
	recipe = {
		{"default:palm_tree"},
	}
})

minetest.register_craft({
	output = 'default:sign_wall_steel',
	recipe = {
		{'', 'default:skeleton_key', ''},
		{'', 'default:tin_ingot', ''},
		{'', 'group:stick', ''},
	}
})

--[[
minetest.register_craft({
	output = 'default:sign_wall_wood',
	recipe = {
		{'', 'group:wood', ''},
		{'', 'default:stick', ''},
	}
})


minetest.register_craft({
	output = 'default:pick_stone',
	recipe = {
		{'default:flint', 'default:flint', 'default:flint'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})
]]
minetest.register_craft({
	output = 'default:pick_steel',
	recipe = {
		{'default:steel_ingot', 'default:steel_ingot', 'default:steel_ingot'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'default:pick_bronze',
	recipe = {
		{'default:bronze_ingot', 'default:bronze_ingot', 'default:bronze_ingot'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

--[[
minetest.register_craft({
	output = 'default:pick_diamond',
	recipe = {
		{'default:diamond', 'default:diamond', 'default:diamond'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})
]]

--[[
minetest.register_craft({
	output = 'default:shovel_stone',
	recipe = {
		{'default:flint'},
		{'group:stick'},
		{'group:stick'},
	}
})
--]]

minetest.register_craft({
	output = 'default:shovel_steel',
	recipe = {
		{'default:steel_ingot'},
		{'group:stick'},
		{'group:stick'},
	}
})

minetest.register_craft({
	output = 'default:shovel_bronze',
	recipe = {
		{'default:bronze_ingot'},
		{'group:stick'},
		{'group:stick'},
	}
})

--[[
minetest.register_craft({
	output = 'default:shovel_diamond',
	recipe = {
		{'default:diamond'},
		{'group:stick'},
		{'group:stick'},
	}
})
--]]

-- Axes
-- Recipes face left to match appearence in textures and inventory

--[[
minetest.register_craft({
	output = 'default:axe_stone',
	recipe = {
		{'default:flint', 'default:flint'},
		{'default:flint', 'group:stick'},
		{'', 'group:stick'},
	}
})
]]

minetest.register_craft({
	output = 'default:axe_steel',
	recipe = {
		{'default:steel_ingot', 'default:steel_ingot'},
		{'default:steel_ingot', 'group:stick'},
		{'', 'group:stick'},
	}
})

minetest.register_craft({
	output = 'default:axe_bronze',
	recipe = {
		{'default:bronze_ingot', 'default:bronze_ingot'},
		{'default:bronze_ingot', 'group:stick'},
		{'', 'group:stick'},
	}
})

--[[
minetest.register_craft({
	output = 'default:axe_diamond',
	recipe = {
		{'default:diamond', 'default:diamond'},
		{'default:diamond', 'group:stick'},
		{'', 'group:stick'},
	}
})
]]

--[[
minetest.register_craft({
	output = 'default:sword_stone',
	recipe = {
		{'default:flint'},
		{'default:flint'},
		{'group:stick'},
	}
})
--]]

minetest.register_craft({
	output = 'default:sword_steel',
	recipe = {
		{'default:steel_ingot'},
		{'default:steel_ingot'},
		{'group:stick'},
	}
})

minetest.register_craft({
	output = 'default:sword_bronze',
	recipe = {
		{'default:bronze_ingot'},
		{'default:bronze_ingot'},
		{'group:stick'},
	}
})

--[[
minetest.register_craft({
	output = 'default:sword_diamond',
	recipe = {
		{'default:diamond'},
		{'default:diamond'},
		{'group:stick'},
	}
})
]]

minetest.register_craft({
	output = 'default:skeleton_key',
	recipe = {
		{'default:gold_ingot'},
	}
})

--[[
minetest.register_craft({
	output = 'default:chest',
	recipe = {
		{'group:wood', 'group:wood', 'group:wood'},
		{'group:wood', '', 'group:wood'},
		{'group:wood', 'group:wood', 'group:wood'},
	}
})

minetest.register_craft({
	output = 'default:chest_locked',
	recipe = {
		{'group:wood', 'group:wood', 'group:wood'},
		{'group:wood', 'default:steel_ingot', 'group:wood'},
		{'group:wood', 'group:wood', 'group:wood'},
	}
})
--]]
minetest.register_craft( {
	type = "shapeless",
	output = "default:chest_locked",
	recipe = { "default:chest", "default:skeleton_key"}
})

--[[
minetest.register_craft({
	output = 'default:furnace',
	recipe = {
		{'default:cobble', 'default:cobble', 'default:cobble'},
		{'default:cobble', '', 'default:cobble'},
		{'default:cobble', 'default:cobble', 'default:cobble'},
	}
})
--]]

minetest.register_craft({
	output = 'default:coalblock',
	recipe = {
		{'default:coal_lump', 'default:coal_lump', 'default:coal_lump'},
		{'default:coal_lump', 'default:coal_lump', 'default:coal_lump'},
		{'default:coal_lump', 'default:coal_lump', 'default:coal_lump'},
	}
})

minetest.register_craft({
	output = 'default:coal_lump 9',
	recipe = {
		{'default:coalblock'},
	}
})

minetest.register_craft({
	output = 'default:steelblock',
	recipe = {
		{'default:steel_ingot', 'default:steel_ingot', 'default:steel_ingot'},
		{'default:steel_ingot', 'default:steel_ingot', 'default:steel_ingot'},
		{'default:steel_ingot', 'default:steel_ingot', 'default:steel_ingot'},
	}
})

minetest.register_craft({
	output = 'default:steel_ingot 9',
	recipe = {
		{'default:steelblock'},
	}
})

minetest.register_craft({
	output = 'default:copperblock',
	recipe = {
		{'default:copper_ingot', 'default:copper_ingot', 'default:copper_ingot'},
		{'default:copper_ingot', 'default:copper_ingot', 'default:copper_ingot'},
		{'default:copper_ingot', 'default:copper_ingot', 'default:copper_ingot'},
	}
})
minetest.register_craft({
	output = 'default:copper_ingot 9',
	recipe = {
		{'default:copperblock'},
	}
})

minetest.register_craft({
	output = "default:tinblock",
	recipe = {
		{"default:tin_ingot", "default:tin_ingot", "default:tin_ingot"},
		{"default:tin_ingot", "default:tin_ingot", "default:tin_ingot"},
		{"default:tin_ingot", "default:tin_ingot", "default:tin_ingot"},
	}
})

minetest.register_craft({
	output = "default:tin_ingot 9",
	recipe = {
		{"default:tinblock"},
	}
})

minetest.register_craft({
	output = "default:bronze_ingot 4",
	type="shapeless",
	recipe =
		{"default:copper_ingot", "default:tin_ingot", "default:copper_ingot", "default:copper_ingot"},
})

minetest.register_craft({
	output = 'default:bronzeblock',
	recipe = {
		{'default:bronze_ingot', 'default:bronze_ingot', 'default:bronze_ingot'},
		{'default:bronze_ingot', 'default:bronze_ingot', 'default:bronze_ingot'},
		{'default:bronze_ingot', 'default:bronze_ingot', 'default:bronze_ingot'},
	}
})

minetest.register_craft({
	output = 'default:bronze_ingot 9',
	recipe = {
		{'default:bronzeblock'},
	}
})

minetest.register_craft({
	output = 'default:goldblock',
	recipe = {
		{'default:gold_ingot', 'default:gold_ingot', 'default:gold_ingot'},
		{'default:gold_ingot', 'default:gold_ingot', 'default:gold_ingot'},
		{'default:gold_ingot', 'default:gold_ingot', 'default:gold_ingot'},
	}
})

minetest.register_craft({
	output = 'default:gold_ingot 9',
	recipe = {
		{'default:goldblock'},
	}
})

minetest.register_craft({
	output = 'default:book',
	recipe = {
		{'default:paper', 'default:paper', ''},
		{'default:paper', 'default:paper', ''},
		{'default:paper', 'default:paper', ''},
	}
})

minetest.register_craft({
	output = 'default:book',
	type="shapeless",
	recipe = { "default:mese_crystal_fragment", "default:book_written" }
})

minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:wood"}
})
minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf_acacia',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:acacia_wood"}
})
minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf_jungle',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:junglewood"}
})
minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf_pine',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:pine_wood"}
})
minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf_palm',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:palm_wood"}
})
minetest.register_craft({
	type='shapeless',
	output = 'default:bookshelf_aspen',
	recipe = { "default:chest_locked", "default:book", "default:book", "default:aspen_wood"}
})

minetest.register_craft({
	output = 'default:mese',
	recipe = {
		{'default:mese_crystal', 'default:mese_crystal', 'default:mese_crystal'},
		{'default:mese_crystal', 'default:mese_crystal', 'default:mese_crystal'},
		{'default:mese_crystal', 'default:mese_crystal', 'default:mese_crystal'},
	}
})

minetest.register_craft({
	output = 'default:mese_crystal 9',
	recipe = {
		{'default:mese'},
	}
})

minetest.register_craft({
	output = 'default:mese_crystal_fragment 9',
	recipe = {
		{'default:mese_crystal'},
	}
})

minetest.register_craft({
	output = "default:mese_crystal",
	recipe = {
		{"default:mese_crystal_fragment", "default:mese_crystal_fragment", "default:mese_crystal_fragment"},
		{"default:mese_crystal_fragment", "default:mese_crystal_fragment", "default:mese_crystal_fragment"},
		{"default:mese_crystal_fragment", "default:mese_crystal_fragment", "default:mese_crystal_fragment"},
	}
})

minetest.register_craft {
	output = 'default:meselamp',
	type="shapeless",
	recipe = {"default:tin_ingot", "flowers:mushroom_red", "flowers:mushroom_red", "flowers:mushroom_red", "flowers:mushroom_red", "default:glass"},
}

--[[
minetest.register_craft({
	output = "default:large_cactus_seedling",
	recipe = {
		{"default:cactus", "default:cactus", "default:cactus"},
		{"default:cactus", "default:cactus", "default:cactus"},
		{"default:cactus", "default:cactus", "default:cactus"},
	}
})
--]]

minetest.register_craft {
	output="default:acacia_bush_stem",
	type="cooking",
	recipe="default:cactus",
	burntime=5,
}
--
-- Cooking recipes
--

minetest.register_craft({
	type = "cooking",
	output = "default:steel_ingot",
	recipe = "default:iron_lump",
	cooktime = 100,
})

minetest.register_craft({
	type = "cooking",
	output = "default:copper_ingot",
	recipe = "default:copper_lump",
	cooktime = 80,
})

minetest.register_craft({
	type = "cooking",
	output = "default:tin_ingot",
	recipe = "default:tin_lump",
	cooktime = 70,
})

minetest.register_craft({
	type = "cooking",
	output = "default:gold_ingot",
	recipe = "default:gold_lump",
	cooktime = 60,
})


minetest.register_craft({
	type = 'cooking',
	output = 'default:gold_ingot',
	recipe = 'default:skeleton_key',
	cooktime = 5,
})

minetest.register_craft({
	type = 'cooking',
	output = 'default:gold_ingot',
	recipe = 'default:key',
	cooktime = 5,
})


--
-- Fuels
--

-- Burn times determined by color.
minetest.register_craft({
	type = "fuel",
	recipe = "default:aspen_tree",
	burntime = 20, })

minetest.register_craft({
	type = "fuel",
	recipe = "default:pine_tree",
	burntime = 24,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:palm_tree",
	burntime = 28, })

minetest.register_craft({
	type = "fuel",
	recipe = "default:tree",
	burntime = 32,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:acacia_tree",
	burntime = 36,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:jungletree",
	burntime = 40,
})


-- Support use of group:wood, includes default:wood which has the same burn time
minetest.register_craft({
	type = "fuel",
	recipe = "default:wood",
	burntime = 8,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:palm_wood",
	burntime = 7,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:acacia_wood",
	burntime = 9,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:pine_wood",
	burntime = 6,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:aspen_wood",
	burntime = 5,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:junglewood",
	burntime = 10,
})

minetest.register_craft({
	type = "fuel",
	recipe = "group:stick",
	burntime = 6,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:coal_lump",
	burntime = 43,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:coalblock",
	burntime = 430,
})

local _=function (item, mat)
	minetest.register_craft {
		output= item,
		recipe = { {mat, mat, mat}, {mat, "group:stick", mat}, {mat, mat, mat} }
	}
end
_("default:bronze_fence", "default:bronze_ingot")
_("default:tin_fence 2", "default:tin_ingot")
_("default:steel_fence 4", "default:steel_ingot")
_("default:gold_fence 8", "default:gold_ingot")
	
