mobs:register_mob("mob_manti:mini_manticore", {
	type = "monster",
	passive = false,
	attacks_monsters=false,
	suicidal=false,
	damage = 2,
	reach = 2,
	attack_type = "dogfight",
	hp_max = 25,
	collisionbox = {-0.4, -0.25, -0.4, 0.4, 0.75, 0.4},
	visual = "mesh",
	mesh = "manticore.b3d",
	textures = {
		{"manticore.png"},
	},
	blood_amount = 80,
	blood_texture = "horror_blood_effect.png",
	visual_size = {x=1.5, y=1.5},
	makes_footstep_sound = true,
	walk_velocity = 2,
	run_velocity = 3.75,
	floats=1,
	jump = true,
	jump_height=6,
	env_dmg= { ["default:ice"]=2 },
	view_range = 24,
	animation = {
		speed_normal = 10,
		speed_run = 20,
		walk_start = 1,
		walk_end = 11,
		stand_start = 11,
		stand_end = 26,
		run_start = 1,
		run_end = 11,
		punch_start = 11,
		punch_end = 26,
	},

	env_alt = {
		["default:junglegrass"]={ "default:junglesapling", 30},
		["default:dry_grass_5"]={ "default:acacia_bush_sapling", 30},
		["default:acacia_bush_sapling"]={"default:acacia_sapling", 10},
		["default:dry_shrub"]={ "default:large_cactus_seedling", 4},
		["default:grass_5"]={ "default:blueberry_bush_sapling", 30},
		["farming:wheat"]={"air",4},
		["farming:cotton"]={"air",4},
		["default:marram_grass_3"]={ "default:palmtree_sapling", 20},
	},

	drops = {
		{name = "farming:seed_cotton", chance=2},
		{name = "farming:seed_cotton", chance=2},
		{name = "default:mese_crystal_fragment", chance=2},
	},
})

mobs:register_spawn("mob_manti:mini_manticore", {"default:dry_grass_5", "default:dry_shrub", "default:junglegrass" }, 20, 0, 750, 3, 999)

--[[
mobs:register_arrow("mob_manti:explosive_missile", {
	visual = "sprite",
	visual_size = {x = 0.8, y = 1},
	textures = {"horror_flame3.png"},
	glow=10,
	velocity = 6,
	tail = 1, -- enable tail
	tail_texture = "horror_flame2.png",

	hit_player = function(self, player)
		mobs:explosion(player:get_pos(), 3)
	end,

	hit_mob = function(self, player)
		mobs:explosion(player:get_pos(), 3)
	end,

	hit_node = function(self, pos, node)
		mobs:explosion(pos, 3)
		end,
})

local arrows={ "mobs_crab:tp_arrow", "mob_wasp:sting_smoke", "mob_spider:net_arrow", "mob_wasp:sting"}

mobs:register_mob("mob_manti:manticore", {
	type = "monster",
	passive = false,
	suicidal=true,
	attacks_monsters=true,
	attack_animals=true,
	damage = 3,
	reach = 2.5,
	-- attack_type = "dogfight",
	attack_type="shoot",
	arrow="mobs_crab:tp_arrow",
	shoot_interval=2,
	shoot_offset=0,
	hp_max = 60,
	collisionbox = {-0.4, -0.5, -0.4, 0.4, 1.25, 0.4},
	visual = "mesh",
	mesh = "manticore.b3d",
	textures = {
		{"manticore.png"},
	},
	blood_amount = 80,
	blood_texture = "horror_blood_effect.png",
	visual_size = {x=2, y=2},
	makes_footstep_sound = true,
	walk_velocity = 1.5,
	run_velocity = 4,
	jump = true,
	jump_height=9,
	--fear_height = 2,
	knock_back=0,
	drops={
		{name = "default:mese_crystal_fragment", chance=2},
		{name = "default:mese_crystal_fragment", chance=2},
		{name = "more_mese:mese_crystal_fragment_green", chance=3},
		{name = "more_mese:mese_crystal_fragment_blue", chance=3},
		{name = "more_mese:mese_crystal_fragment_grey", chance=3},
	},
	env_dmg= { ["default:ice"]=1, ["smoke:smog"]=0, ["mobs:cobweb"]=0 },
	view_range = 24,
	animation = {
		speed_normal = 10,
		speed_run = 20,
		walk_start = 1,
		walk_end = 11,
		stand_start = 0,
		stand_end = 0,
		run_start = 1,
		run_end = 11,
		punch_start = 11,
		punch_end = 26,
	},
	do_custom=function(self)
		if self.state~="attack" then return end
		self.arrow=arrows[math.random(1, #arrows)]

	end

})

-- minetest.register_craftitem("mob_manti:manticore_gem", {description="Red Gem", inventory_image="dmobs_gem_fire.png"})

mobs:spawn({
	name = "mob_manti:manticore",
	nodes = {"default:desert_sand"},
	neighbors={"default:cactus"},
	chance = 100,
	active_object_count=4,
	interval=17,
	min_height=0,
})
]]
