-- Compass mod
-- Code: by Astrobe, MIT license.
-- Texture: taken from the "Magic compass" mod by Zughy, CC BY-SA 4.0.

local st=minetest.get_mod_storage()
local playerwp={}

local function update_wp(name, pos)
	if not name then return end
	local player=minetest.get_player_by_name(name)
	if not player then return end
	if playerwp[name] then
		player:hud_remove(playerwp[name])
		playerwp[name]=nil
	end
	if pos then
		playerwp[name]=player:hud_add {
			hud_elem_type="waypoint",
			name="+",
			number=0x808080,
			precision=1,
			world_pos=pos }
	end
end

compass=
{
	get_wp2=function(name)
		if not playerwp[name] then return nil end
		return minetest.deserialize(st:get_string(name))
	end,
	set_wp2=function(name, pos)
		st:set_string(name, minetest.serialize(pos))
		update_wp(name, pos)
	end

}


minetest.register_on_joinplayer(function(player)
	local name=player:get_player_name()
	local p=minetest.deserialize(st:get_string(name))
	if p then update_wp(name, p) end
	end)

--[[
minetest.register_chatcommand("wp",
{
	param="<name> or *",
	description="Sets the custom waypoint of a player to yours (if they don't already have one set); '*' clears your own waypoint.",
	privs={interact=true},
	func = function(name, param)
		if not playerwp[name] then return false, "Your waypoint is not set" end
		if param=="*" then
			st:set_string(name, "")
			update_wp(name, nil)
			return true, "Waypoint cleared"
		end
		if not minetest.player_exists(param) then return false, "Who?" end
		if playerwp[param] then return false, "Player's waypoint already in use." end
		local pos=minetest.deserialize(st:get_string(name))
		st:set_string(param, minetest.serialize(pos))
		update_wp(param, pos)
		return true, "Waypoint set"
	end

})
]]

minetest.register_craftitem("compass:compass", {
	description = "Compass.\nDetects nearby ores when activated, as well as heading, time and date.\nSingle-use.\nGet: from loot boxes.",
	inventory_image = "compass.png",
	sound = {breaks = "default_tool_breaks"},
	groups={not_repaired_by_anvil=1},
	on_use=function(itemstack, player)
		local name=player:get_player_name()
		local t=minetest.get_timeofday()*1440
		local bearing=math.floor(player:get_look_horizontal()*180/math.pi)
		--[[
		if minetest.find_node_near(player:get_pos(), 3, {name="group:ore"}) then
			bearing="???"
		end
		--]]
		minetest.chat_send_player(name,"Bearing: "..bearing.." Altitude: "..math.floor(player:get_pos().y)..string.format(" Time: Moon %d, %02d:%02d",minetest.get_day_count(), t/60,t%60).." Light level: "..minetest.get_node_light(player:get_pos()))

		local zero={x=0, y=0, z=0}
		local pos=player:get_pos()
		local vol=5
		local p1={x=pos.x-vol, y=pos.y-vol, z=pos.z-vol}
		local p2={x=pos.x+vol, y=pos.y+vol, z=pos.z+vol}
		for _,ore in ipairs(minetest.find_nodes_in_area(p1, p2, "group:ore")) do
			minetest.add_particlespawner
			{
				amount=200,
				time=20,
				minpos=ore,
				maxpos=ore,
				minvel={x=-5,y=-5,z=-5},
				maxvel={x=5,y=5,z=5},
				minacc=zero,
				maxacc=zero,
				minsize=4,
				maxsize=4,
				glow=7,
				texture="default_mineral_mese.png",
				playername=player:get_player_name()
			}
		end
		--itemstack:add_wear(65536/64)
		itemstack:take_item()
		return itemstack
	end,

	--[[
	on_place=function(itemstack, clicker, pointed_thing)
		if clicker and pointed_thing then
			local pos=pointed_thing.under
			local node=minetest.get_node(pos).name
			if node =="beacon:beacon" then
				local name=clicker:get_player_name()
				if name and not mf.clan_ok(name, pos) then
					return itemstack
				end
				st:set_string(name, minetest.serialize(pos))
				update_wp(name, pos)
				itemstack:take_item()
			elseif node=="compass:recorder" then
				local meta=minetest.get_meta(pos)
				local wp=meta:get_string("wp")
				if wp=="" then return itemstack end
				-- yeah, it's a bit dumb because we deserialize and it is serialize again for storage.
				compass.set_wp2(clicker:get_player_name(), minetest.deserialize(wp))
				itemstack:take_item()
			end
			return itemstack
		end
	end
	]]
})

--[[
minetest.register_node("compass:recorder",
{
	description="Waypoint recorder.\nMemorizes your second waypoint when placed.\nFeed a compass to set your second waypoint.",
	tiles={"xdecor_stone_rune.png^compass.png", "xdecor_stone_rune.png"},
	paramtype="light",
	groups={choppy=3},
	sounds=default.node_sound_wood_defaults(),
	after_place_node=function(pos, placer, itemstack)
		if not placer or not placer:is_player() then return true end
		local name=placer:get_player_name()
		local meta=minetest.get_meta(pos)
		local wp=st:get_string(name)
		if wp=="" then
			minetest.chat_send_player(name, "Your secondary waypoint is not set!")
		else
			meta:set_string("wp", st:get_string(name))
		end
		return nil
	end
})
		
minetest.register_craft
{
	output="compass:recorder",
	type="shapeless",
	recipe={"compass:compass", "dungeon_crates:crate", "default:mese_crystal"}
}
]]
