-- Melding mod
-- Author: Astrobe
-- Code licence: Same as Minetest.
-- "Meldite" texture stolen from the "Too many stones" mod by JoeEnderman. MIT licence.

--[[ TODO remove texture and credit.
minetest.register_node("melding:meldite", {
	description = "Meldite",
	tiles = {"tms_sugilite_cobble.png"},
	groups = {cracky = 1},
	damage_per_second=1,
	drop = {
		max_items = 1,
		items = {
			{items = {"default:copper_lump"}, rarity = 8},
			{items = {"default:tin_lump"}, rarity = 16},
			{items = {"default:iron_lump"}, rarity = 32},
			{items = {"default:gold_lump"}, rarity = 64},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
]]

minetest.register_node("melding:node",
{
	description = "Melding block",
	tiles = {
		{
			name = "nether_portal_alt.png",
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.7,
			},
		},
	},
	drawtype = "glasslike",
	groups={nopicker=1},
	paramtype = "light",
	paramtype2 = "colorfacedir",
	palette = "nether_portals_palette.png",
	post_effect_color = { a = 160, r = 128, g = 0, b = 80 },
	sunlight_propagates = false,
	use_texture_alpha = "opaque",
	walkable = false,
	diggable = false,
	pointable = false,
	buildable_to = false,
	drowning=2,
	move_resistance=1,
	light_source=11,
	is_ground_content = false,
	drop = "",
})

-- Here is our good old friend, miss ABM.
minetest.register_abm{
	label="melding expension",
	nodenames="melding:node",
	neighbors= "air",
	interval=1801,
	chance=4,
	catch_up=true,
	action=function(pos)
		--  This works well for us because find_node-near looks at the node right above first
		--  and we prefer an expand-up first behaviour.
		local p=minetest.find_node_near(pos, 1, {name="air"})
		if not p then return end
		if not minetest.is_protected(p) then
			minetest.swap_node(p, {name="melding:node"})
		end
	end,
}

--[[
minetest.register_chatcommand("cm",
{
	description="clears melding in a ten blocks radius",
	privs={server=true},
	func=function(name)
		local pos=minetest.get_player_by_name(name):get_pos()
		local p=minetest.find_node_near(pos, 10, {name="melding:node"})
		while p  do
			minetest.remove_node(p)
			p=minetest.find_node_near(pos, 10, {name="melding:node"})
		end
	end
})
]]


