-- This is derived from the "Damage output particles" mod by "davidthecreator":
-- https://forum.minetest.net/viewtopic.php?t=24347
-- 
-- Author: Astrobe
-- License: CC0

damage_number={}

local textures= { "dmg_num_1.png", "dmg_num_2.png", "dmg_num_3.png", "dmg_num_4.png", "dmg_num_5.png", "dmg_num_6.png", "dmg_num_7.png", "dmg_num_8.png", "dmg_num_9.png" }

function damage_number.spawn(pos, dmg)
	local texture=textures[math.abs(dmg)] or "dmg_num_0.png^[transform1"	 -- zero for debug; should not happen.
	minetest.add_particle {
		pos = pos,
		velocity = {x=0, y=4, z=0},
		-- acceleration = {x=math.random(-8,8), y=math.random(-8,-16), z=math.random(-8,8)},
		expirationtime = 1.5,
		size = 9,
		collisiondetection = false,
		vertical = false,
		texture = texture,
		glow = 10,
		}
end

--[[
minetest.register_on_player_hpchange(
	function(player, hp_change)
		-- don't display for small damage or healing
		if hp_change > -1 then return end
		local pos=player:get_pos()
		damage_number.spawn(pos, -hp_change)
	end)
	]]

