-- Minetest 0.4 mod: default
-- See README.txt for licensing and other information.

-- The API documentation in here was moved into game_api.txt

-- Definitions made by this mod that other mods can use too
default = {}

default.LIGHT_MAX = 14

-- GUI related stuff
--[[
minetest.register_on_joinplayer(function(player)
	player:set_formspec_prepend([=[
			bgcolor[#080808BB;true]
			background[5,5;1,1;gui_formbg.png;true]
			listcolors[#00000069;#5A5A5A;#141318;#30434C;#FFF] ]=])
end)
]]
minetest.register_on_joinplayer(function(player)
	player:set_formspec_prepend([=[
			listcolors[#00000069;#5A5A5A;#141318;#30434C;#FFF] ]=])
end)

function default.get_hotbar_bg(x,y)
	local out = ""
	for i=0,7,1 do
		out = out .."image["..x+i..","..y..";1,1;gui_hb_bg.png]"
	end
	return out
end

default.gui_survival_form = "size[8,8.5]"..
			"list[current_player;main;0,4.25;8,1;]"..
			"list[current_player;main;0,5.5;8,3;8]"..
			"list[current_player;craft;1.75,0.5;3,3;]"..
			"list[current_player;craftpreview;5.75,1.5;1,1;]"..
			"image[4.75,1.5;1,1;gui_furnace_arrow_bg.png^[transformR270]"..
			"listring[current_player;main]"..
			"listring[current_player;craft]"..
			default.get_hotbar_bg(0,4.25)

-- Load files
local default_path = minetest.get_modpath("mf_default")

dofile(default_path.."/functions.lua")
dofile(default_path.."/trees.lua")
dofile(default_path.."/nodes.lua")
for _, node in ipairs {
	"default:leaves",
	"default:jungleleaves",
	"default:acacia_leaves", "default:aspen_leaves",
	"default:pine_needles",
	"default:palm_leaves",


} do
	minetest.override_item(node,
	{
		-- drawtype="mesh",
		-- mesh="bushy_leaves_cheap_model.obj",
		drawtype="firelike",
		paramtype="light",
		sunlight_propagates=false,
		move_resistance=1,
		post_effect_color_shaded=true,
		waving=2
	})
end

dofile(default_path.."/chests.lua")
dofile(default_path.."/furnace.lua")
dofile(default_path.."/tools.lua")
dofile(default_path.."/craftitems.lua")
dofile(default_path.."/crafting.lua")
dofile(default_path.."/mapgen.lua")
dofile(default_path.."/aliases.lua")
dofile(default_path.."/legacy.lua")
