core.register_craftitem("mf_vessels:bottle",
{
	description="Glass bottle.",
	inventory_image="vessels_glass_bottle.png"
})

core.register_craftitem("mf_vessels:juice_bottle",
{
	description="Invisibility potion.\nConsumes 1 mana/s, ends when out of mana.",
	inventory_image="juice_bottle.png",
	on_use=function(stack, user, pointed)
		if user then
			mf.makeInvisible(user)
			local p=user:get_pos()
			p.y=p.y+1.5
			user:set_properties{visual_size={x=0.01, y=0.01}}
			stack:take_item(1)
			local radius=2
			minetest.add_particlespawner({
				amount = 250,
				time = 0.5,
				minexptime=0.1,
				maxexptime=0.5,
				pos = p,
				minvel = {x = -radius, y = -radius, z = -radius},
				maxvel = {x = radius, y = radius, z = radius},
				texture ={name="default_item_smoke.png", alpha_tween={1,0}} ,
			})
			local name=user:get_player_name()
			mfplayers[name].energy=mfplayers[name].max_energy
			return stack
		end
	end
})

core.register_node("mf_vessels:shelf",
{
	description = "Vessels Shelf",
	tiles = {"default_chest_top.png", "default_chest_top.png", "default_chest_top.png",
		"default_chest_top.png", "default_chest_top.png", "vessels_shelf.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {choppy = 3, flammable = 3, furniture=1, protected=1},
	sounds = default.node_sound_wood_defaults()
})

core.register_craft({
	output = "mf_vessels:shelf",
	type="shapeless",
	recipe = {
		"mf_vessels:bottle", "mf_vessels:bottle", "mf_vessels:bottle", "mf_vessels:bottle",
		"mf_vessels:bottle", "mf_vessels:bottle", "mf_vessels:bottle", "mf_vessels:bottle",
		"default:chest_locked",
	}
})
core.register_craft({
	output = "mf_vessels:juice_bottle",
	type="shapeless",
	recipe = {
		"default:blueberries", "flowers:mushroom_red", "default:blueberries",
		"default:blueberries", "default:blueberries", "default:blueberries",
		"mf_vessels:bottle",
	}
})
