minetest.register_node("bamboo:bamboo", {
	description = "Bamboo",
	drawtype = "nodebox",
	paramtype = "light",
	tiles = {"bamboo_top.png", "bamboo_bottom.png", "bamboo.png"},
	sunlight_propagates = true,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
	},
	node_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
	},
	groups = {choppy = 2, flammable = 2, attached_node = 1},
	sounds = default.node_sound_wood_defaults(),
	on_place = function(itemstack, placer, pointed_thing)
		local under = pointed_thing.above - vector.new(0, 1, 0)
		if minetest.get_node(under).name == "air" then
		return itemstack
		end

		if minetest.get_node(under).name == "bamboo:bamboo_top" then
		minetest.set_node(under, {name = "bamboo:bamboo"})
		end

		if not minetest.settings:get_bool("creative_mode") then
			itemstack:take_item()
		end

		minetest.set_node(pointed_thing.above, {name = "bamboo:bamboo_top"})

		return itemstack
	end
})

minetest.register_node("bamboo:dry_bamboo", {
	description = "Dry Bamboo",
	drawtype = "nodebox",
	paramtype = "light",
	tiles = {"dry_bamboo_top.png", "dry_bamboo_bottom.png", "dry_bamboo.png"},
	sunlight_propagates = true,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
	},
	node_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
	},
	groups = {choppy = 2, flammable = 2, attached_node = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("bamboo:bamboo_top", {
	description = "Bamboo Top",
	drawtype = "nodebox",
	paramtype = "light",
	tiles = {"bamboo_top.png", "bamboo_bottom.png", "bamboo_leaves.png", "bamboo_leaves.png", "bamboo_leaves.png", "bamboo_leaves.png"},
	sunlight_propagates = true,
	selection_box = {
		type = "fixed",
		fixed = {-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
	},
	node_box = {
		type = "fixed",
		fixed = {{-2 / 16, -0.5, -2 / 16, 2 / 16, 0.5, 2 / 16},
			{-0.5, -0.5, 0, 0.5, 0.5, 0},
			{0, -0.5, -0.5, 0, 0.5, 0.5}}
	},
	drop = "bamboo:bamboo",
	groups = {choppy = 2, flammable = 2, attached_node = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("bamboo:bamboo_bundle", {
	description = "Bamboo Bundle",
	tiles = {"bamboo_block.png", "bamboo_block_side.png"},
	paramtype2 = "facedir",
	groups = {choppy = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node,
})

minetest.register_node("bamboo:dry_bamboo_bundle", {
	description = "Dry Bamboo Bundle",
	tiles = {"dry_bamboo_block.png", "dry_bamboo_block_side.png"},
	paramtype2 = "facedir",
	groups = {choppy = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node,
})


stairs.register_stair_and_slab("dry_bamboo",
			"bamboo:dry_bamboo_bundle",
			{choppy = 2, flammable = 2},
			{"dry_bamboo_block.png", "dry_bamboo_block_side.png"},
			"Dry Bamboo Stair",
			"Dry Bamboo Slab",
			default.node_sound_wood_defaults()
)

local bamboo_fence_texture = "default_fence_overlay.png^" .. "dry_bamboo_fence_inventory.png" ..
			"^default_fence_overlay.png^[makealpha:255,126,126"

local bamboo_fence_rail_texture = "default_fence_rail_overlay.png^" .. "dry_bamboo_fence_rail_inventory.png" ..
			"^default_fence_rail_overlay.png^[makealpha:255,126,126"

local fencedata = {
	description = "Dry Bamboo Fence",
	tiles = {"dry_bamboo_fence.png", "dry_bamboo_fence.png", "dry_bamboo_fence_side.png"},
	texture = "",
	inventory_image = bamboo_fence_texture,
	wield_image = bamboo_fence_texture,
	material = "bamboo:dry_bamboo",
	groups = {choppy = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults(),
}

local fencegatedata = {
	description = "Dry Bamboo Fence Gate",
	texture = "dry_bamboo_fence_gate.png",
	material = "bamboo:dry_bamboo",
	groups = {choppy = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults(),
}

default.register_fence("bamboo:dry_bamboo_fence", table.copy(fencedata))
doors.register_fencegate("doors:gate_dry_bamboo", table.copy(fencegatedata))

fencedata.description = "Dry Bamboo Fence Rail"
fencedata.tiles = {"dry_bamboo_fence_rail.png", "dry_bamboo_fence_rail.png", "dry_bamboo_fence_side_rail.png"}
fencedata.inventory_image = bamboo_fence_rail_texture
fencedata.wield_image = bamboo_fence_rail_texture

default.register_fence_rail("bamboo:dry_bamboo_fence_rail", table.copy(fencedata))

minetest.register_craft({
	output = "bamboo:bamboo_bundle",
	recipe = {
		{"bamboo:bamboo", "bamboo:bamboo", "bamboo:bamboo"},
		{"bamboo:bamboo", "bamboo:bamboo", "bamboo:bamboo"},
		{"bamboo:bamboo", "bamboo:bamboo", "bamboo:bamboo"},
	},
})

minetest.register_craft({
	output = "default:stick 2",
	recipe = {
		{"bamboo:dry_bamboo"},
		{"bamboo:dry_bamboo"},
	},
})

minetest.register_craft({
	output = "bamboo:dry_bamboo_bundle",
	recipe = {
		{"bamboo:dry_bamboo", "bamboo:dry_bamboo", "bamboo:dry_bamboo"},
		{"bamboo:dry_bamboo", "bamboo:dry_bamboo", "bamboo:dry_bamboo"},
		{"bamboo:dry_bamboo", "bamboo:dry_bamboo", "bamboo:dry_bamboo"},
	},
})

minetest.register_craft({
	output = "bamboo:bamboo 9",
	type = "shapeless",
	recipe = {"bamboo:bamboo_bundle"}
})

minetest.register_craft({
	output = "bamboo:dry_bamboo 9",
	type = "shapeless",
	recipe = {"bamboo:dry_bamboo_bundle"}
})

local bamboo_schematic = {
	size = {x = 1, y = 16, z = 1},
	data = {
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo"},
		{name = "bamboo:bamboo_top"},

	},
	yslice_prob = {
		{ypos=1, prob=35},
		{ypos=2, prob=35},
		{ypos=3, prob=35},
		{ypos=4, prob=35},
		{ypos=5, prob=35},
		{ypos=6, prob=35},
		{ypos=7, prob=35},
		{ypos=8, prob=35},

	},
}

minetest.register_decoration({
	name = "bamboo:bamboo",
	deco_type = "schematic",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	noise_params = {
		offset = -0.3,
		scale = 0.7,
		spread = {x = 200, y = 200, z = 200},
		seed = 765,
		octaves = 3,
		persist = 0.7
	},
	biomes = {"rainforest"},
	schematic = bamboo_schematic,
	y_max = 32,
	y_min = 1,
})

function grow_bamboo(pos, node)
	local abovepos = pos + vector.new(0, 1, 0)
	if minetest.get_node(abovepos).name ~= "air" then
		return
	end
	local height = 0
	while (node.name == "bamboo:bamboo" or node.name == "bamboo:bamboo_top") and height < 14 do
		height = height + 1
		pos.y = pos.y - 1
		node = minetest.get_node(pos)
	end
	if height >= 13 then
		return
	end
	if minetest.get_node_light(abovepos) < 13 then
		return
	end
	local name = minetest.get_node(pos).name
	if name ~= "default:dirt" and
		name ~= "default:dirt_with_grass" and
		name ~= "default:dirt_with_dry_grass" and
		name ~= "default:dirt_with_rainforest_litter" and
		name ~= "default:dry_dirt" and
		name ~= "default:dry_dirt_with_dry_grass" then
		pos.y = pos.y + 1
		node = minetest.get_node(pos)
		while (node.name == "bamboo:bamboo" or node.name == "bamboo:bamboo_top")  do
			minetest.set_node(pos, {name = "bamboo:dry_bamboo"})
			pos.y = pos.y + 1
			node = minetest.get_node(pos)
		end
		return true
	end

	minetest.set_node(abovepos, {name = "bamboo:bamboo_top"})
	if minetest.get_node(abovepos - vector.new(0, 1, 0)).name == "bamboo:bamboo_top" then
		minetest.set_node(abovepos - vector.new(0, 1, 0), {name = "bamboo:bamboo"})
	end
	return true
end

minetest.register_abm({
	label = "Grow bamboo",
	nodenames = {"bamboo:bamboo_top"},
	interval = 14,
	chance = 30,
	action = function(...)
		grow_bamboo(...)
	end
})

minetest.register_abm({
	label = "Grow bamboo leaves",
	nodenames = {"bamboo:bamboo"},
	interval = 14,
	chance = 30,
	action = function(pos, node)
		if minetest.get_node(pos + vector.new(0, 1, 0)).name ~= "air" then
			return
		end
		local belownode = minetest.get_node(pos - vector.new(0, 1, 0)).name
		if belownode ~= "default:dirt" and
		belownode ~= "default:dirt_with_grass" and
		belownode ~= "default:dirt_with_dry_grass" and
		belownode ~= "default:dirt_with_rainforest_litter" and
		belownode ~= "default:dry_dirt" and
		belownode ~= "default:dry_dirt_with_dry_grass" then
			minetest.set_node(pos, {name = "bamboo:dry_bamboo"})
			return true
		end
		
		minetest.set_node(pos, {name = "bamboo:bamboo_top"})
		return true

	end
})

minetest.register_craft({
	type = "fuel",
	recipe = "bamboo:dry_bamboo",
	burntime = 2,
})

minetest.register_craft({
	type = "fuel",
	recipe = "bamboo:dry_bamboo_bundle",
	burntime = 18,
})

--Aliases for compatibility with other mods with the bamboo namespace.
--This mod can be used as a drop-in replacement for those mods.

minetest.register_alias("bamboo:block", "bamboo:bamboo_bundle")
minetest.register_alias("bamboo:item", "bamboo:bamboo")
minetest.register_alias("bamboo:sapling", "bamboo:bamboo")
minetest.register_alias("bamboo:bamboo_dry", "bamboo:dry_bamboo")
minetest.register_alias("bamboo:item_dry", "bamboo:dry_bamboo")
minetest.register_alias("bamboo:block_dry", "bamboo:dry_bamboo_bundle")

minetest.register_alias("bamboo:trunk", "bamboo:bamboo")
minetest.register_alias("bamboo:wood", "bamboo:dry_bamboo_bundle")
minetest.register_alias("bamboo:leaves", "bamboo:bamboo_bundle")
minetest.register_alias("bamboo:sprout", "bamboo:bamboo_top")
minetest.register_alias("bamboo:fence", "bamboo:dry_bamboo_fence")
minetest.register_alias("bamboo:gate_closed", "doors:gate_dry_bamboo_closed")
minetest.register_alias("bamboo:gate_open", "doors:gate_dry_bamboo_open")
minetest.register_alias("bamboo:fence_rail", "bamboo:dry_bamboo_fence_rail")
minetest.register_alias("stairs:stair_bamboo_trunk", "stairs:stair_dry_bamboo")
minetest.register_alias("stairs:stair_inner_bamboo_trunk", "stairs:stair_inner_dry_bamboo")
minetest.register_alias("stairs:stair_outer_bamboo_trunk", "stairs:stair_outer_dry_bamboo")
minetest.register_alias("stairs:slab_bamboo_trunk", "stairs:slab_dry_bamboo")