carts:register_rail("copper_rails:copper_rail", {
	description = "Copper Rail",
	drawtype = "nodebox",
	paramtype2 = "facedir",
	tiles = {
		"copper_rail.png"
	},
	node_box = {
		type = "fixed",
		fixed = {-1/2, -31/64, -1/2, 1/2, -31/64, 1/2},
	},
	inventory_image = "copper_rail.png",
	groups = carts:get_rail_groups(),
}, {acceleration = 1})

minetest.register_craft({
	output = "copper_rails:copper_rail 18",
	recipe = {
		{"default:copper_ingot", "group:wood", "default:copper_ingot"},
		{"default:copper_ingot", "default:mese_crystal", "default:copper_ingot"},
		{"default:copper_ingot", "group:wood", "default:copper_ingot"},
	}
})


local old_on_step = minetest.registered_entities["carts:cart"].on_step

minetest.registered_entities["carts:cart"].on_step = function(self, dtime)
	local pos = self.object:get_pos()
	local node = minetest.get_node(pos)
	if node.name == "copper_rails:copper_rail" then

	local acc = vector.new(0, 0, 0)

	if node.param2 == 0 then
		acc = vector.new(0, 0, 4)
		self.old_dir = vector.new(0, 0, 1)
	elseif node.param2 == 1 then
		acc = vector.new(4, 0, 0)
		self.old_dir = vector.new(1, 0, 0)
	elseif node.param2 == 2 then
		acc = vector.new(0, 0, -4)
		self.old_dir = vector.new(0, 0, -1)
	elseif node.param2 == 3 then
		acc = vector.new(-4, 0, 0)
		self.old_dir = vector.new(-1, 0, 0)
	end

	self.old_pos = vector.round(self.object:get_pos())

	if self.punched then
		self.object:set_velocity(vector.add(self.object:get_velocity(), self.velocity))
		self.old_dir.y = 0
		self.punched = false
	end


	local vel_len = vector.length(self.object:get_velocity())
	if vel_len > carts.speed_max then
		vel = vector.multiply(self.object:get_velocity(), carts.speed_max / vel_len)
		self.object:set_velocity(vel)
	end
	if vel_len >= carts.speed_max and vector.length(self.object:get_acceleration()) > 0 then
		self.object:set_acceleration(vector.new(0, 0, 0))
	elseif self.object:get_velocity() ~= vector.new(0, 0, 0) then
		self.object:set_acceleration(acc)
	end

	else
		old_on_step(self, dtime)
	end

end
