large_bricks_nodes = {
	{"default:stone_block", "default_stone_block.png", "default_stone.png", "stonebrick", "Stone Brick"},
	{"default:desert_stone_block", "default_desert_stone_block.png", "default_desert_stone.png", "desert_stonebrick", "Desert Stone Brick"},
	{"default:desert_sandstone_block", "default_desert_sandstone_block.png", "default_desert_sandstone.png", "desert_sandstone_brick", "Desert Sandstone Brick"},
	{"default:sandstone_block", "default_sandstone_block.png", "default_sandstone.png", "sandstone_brick", "Sandstone Brick"},
	{"default:silver_sandstone_block", "default_silver_sandstone_block.png", "default_silver_sandstone.png", "silver_sandstone_brick", "Silver Sandstone Brick"},
	{"default:obsidian_block", "default_obsidian_block.png", "default_obsidian.png", "obsidian_brick", "Obsidian Brick"},

}


if minetest.get_modpath("badlands") ~= nil then
	table.insert(large_bricks_nodes, {"badlands:red_sandstone_block", minetest.registered_nodes["badlands:red_sandstone_block"].tiles[1], minetest.registered_nodes["badlands:red_sandstone"].tiles[1], "red_sandstone_brick", "Red Sandstone Brick"})
end

for i = 1, #large_bricks_nodes do
local ingredient, outerimg, innerimg, brickname, brickdesc = unpack(large_bricks_nodes[i])

minetest.register_node("large_bricks:large_" .. brickname, {
	description = "Large " .. brickdesc,
	tiles = {outerimg},
	is_ground_content = false,
	groups = {cracky = 2, stone = 1},
	sounds = default.node_sound_stone_defaults(),

	after_place_node = function(block, itemstack, placer, pointed_thing)
		
		if minetest.get_node(block + vector.new(1, 0, 0)).name == "large_bricks:large_" .. brickname then

			minetest.set_node(block, {name = "large_bricks:large_" .. brickname .. "_left"})
			minetest.set_node(block + vector.new(1, 0, 0), {name = "large_bricks:large_" .. brickname .. "_right"})

		elseif minetest.get_node(block - vector.new(1, 0, 0)).name == "large_bricks:large_" .. brickname then

			minetest.set_node(block, {name = "large_bricks:large_" .. brickname .. "_right"})
			minetest.set_node(block - vector.new(1, 0, 0), {name = "large_bricks:large_" .. brickname .. "_left"})

		elseif minetest.get_node(block + vector.new(0, 0, 1)).name == "large_bricks:large_" .. brickname then

			minetest.set_node(block, {name = "large_bricks:large_" .. brickname .. "_back"})
			minetest.set_node(block + vector.new(0, 0, 1), {name = "large_bricks:large_" .. brickname .. "_front"})

		elseif minetest.get_node(block - vector.new(0, 0, 1)).name == "large_bricks:large_" .. brickname then

			minetest.set_node(block, {name = "large_bricks:large_" .. brickname .. "_front"})
			minetest.set_node(block - vector.new(0, 0, 1), {name = "large_bricks:large_" .. brickname .. "_back"})

		else 

			minetest.set_node(block, {name = "large_bricks:large_" .. brickname})
		end
	end
})

local leftimage = outerimg .. "^([combine:16x16:1,0=" .. outerimg .. "^[mask:overlay_left.png)^(" .. innerimg .. "^[mask:overlay_left_2.png)"
local rightimage = outerimg .. "^([combine:16x16:-1,0=" .. outerimg .. "^[mask:overlay_right.png)^(" .. innerimg .. "^[mask:overlay_right_2.png)"
local frontimage = outerimg .. "^([combine:16x16:0,1=" .. outerimg .. "^[mask:overlay_top.png)^(" .. innerimg .. "^[mask:overlay_top_2.png)"
local backimage = outerimg .. "^([combine:16x16:0,-1=" .. outerimg .. "^[mask:overlay_bottom.png)^(" .. innerimg .. "^[mask:overlay_bottom_2.png)"


minetest.register_node("large_bricks:large_" .. brickname .. "_left", {
	description = "Large " .. brickdesc .. " Left",
	drop = "large_bricks:large_" .. brickname,
	tiles = {leftimage, leftimage, innerimg, outerimg, rightimage, leftimage},
	is_ground_content = false,
	groups = {cracky = 2, stone = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("large_bricks:large_" .. brickname .. "_right", {
	description = "Large " .. brickdesc .. " Right",
	drop = "large_bricks:large_" .. brickname,
	tiles = {rightimage, rightimage, outerimg, innerimg, leftimage, rightimage},
	is_ground_content = false,
	groups = {cracky = 2, stone = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("large_bricks:large_" .. brickname .. "_front", {
	description = "Large " .. brickdesc .. " Front",
	drop = "large_bricks:large_" .. brickname,
	tiles = {frontimage, backimage, rightimage, leftimage, outerimg, innerimg},
	is_ground_content = false,
	groups = {cracky = 2, stone = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("large_bricks:large_" .. brickname .. "_back", {
	description = "Large " .. brickdesc .. " Back",
	drop = "large_bricks:large_" .. brickname,
	tiles = {backimage, frontimage, leftimage, rightimage, innerimg, outerimg},
	is_ground_content = false,
	groups = {cracky = 2, stone = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = "large_bricks:large_" .. brickname .. " 2",
	recipe = {
		{ingredient, ingredient},
	}
})

end