function create_item(pos, item)
	
	minetest.spawn_item(pos + vector.new(math.random(-50, 50) / 100, 1 + math.random(0, 70) / 100, math.random(-50, 50) / 100), item)

end

minetest.register_node("sieves:sieve", {
	description = "Sieve",
	drawtype = "nodebox",
	paramtype = "light",
	sunlight_propagates = true,
	tiles = {"sieve_top.png", "sieve_top.png", "sieve_side.png"},
	groups = {choppy = 3, oddly_breakable_by_hand = 1},
	sounds = default.node_sound_sand_defaults(),
	node_box = {
	type = "fixed",
	fixed = {
		{-0.5000, -0.5000, -0.5000, -0.3750, 0.3750, -0.3750},
		{0.3750, -0.5000, -0.5000, 0.5000, 0.3750, -0.3750},
		{-0.5000, -0.5000, 0.3750, -0.3750, 0.3750, 0.5000},
		{0.3750, -0.5000, 0.3750, 0.5000, 0.3750, 0.5000},
		{0.3750, 0.3750, -0.5000, 0.5000, 0.5000, 0.5000},
		{-0.5000, 0.3750, -0.5000, -0.3750, 0.5000, 0.5000},
		{-0.3750, 0.3750, -0.5000, 0.3750, 0.5000, -0.3750},
		{-0.3750, 0.3750, 0.3750, 0.3750, 0.5000, 0.5000},
		{-0.3750, 0.5000, -0.3750, 0.3750, 0.5000, 0.3750}
	}},
	collision_box = {
	type = "fixed",
	fixed = {
		{-0.5000, -0.5000, -0.5000, -0.3750, 0.3750, -0.3750},
		{0.3750, -0.5000, -0.5000, 0.5000, 0.3750, -0.3750},
		{-0.5000, -0.5000, 0.3750, -0.3750, 0.3750, 0.5000},
		{0.3750, -0.5000, 0.3750, 0.5000, 0.3750, 0.5000},
		{-0.5000, 0.3750, -0.5000, 0.5000, 0.5000, 0.5000}

	}},
	
	on_rightclick = function(pos, node, digger, itemstack)
		if (itemstack:get_name() ~= "default:sand" and itemstack:get_name() ~= "default:desert_sand" and itemstack:get_name() ~= "default:silver_sand") then
			return
		end
		itemstack:take_item()
		if (math.random(0, 5) == 0) then
			create_item(pos, "junk_items:pebble")
		elseif (math.random(0, 7) == 0) then
			create_item(pos, "junk_items:broken_stick")
		elseif (math.random(0, 8) == 0) then
			create_item(pos, "junk_items:flint_shard")
		elseif (math.random(0, 9) == 0) then
			create_item(pos, "default:stick")
		elseif (math.random(0, 11) == 0) then
			create_item(pos, "junk_items:fish_skeleton")
		elseif (math.random(0, 13) == 0) then
			create_item(pos, "nuggets:tin_nugget")
		elseif (math.random(0, 16) == 0) then
			create_item(pos, "nuggets:copper_nugget")
		elseif (math.random(0, 20) == 0) then
			create_item(pos, "nuggets:steel_nugget")
		elseif (math.random(0, 24) == 0) then
			create_item(pos, "nuggets:gold_nugget")
		elseif (math.random(0, 28) == 0) then
			create_item(pos, "default:mese_crystal_fragment")
		elseif (math.random(0, 32) == 0) then
			create_item(pos, "nuggets:diamond_shard")
		end
	end

})

minetest.register_craft({
	output = "sieves:sieve",
	recipe = {
		{"default:stick", "default:stick", "default:stick"},
		{"default:stick", "farming:string", "default:stick"},
		{"default:stick", "default:stick", "default:stick"},
	}
})