default.chest.register_chest("stone_chests:stone_chest", {
	description = "Stone Chest",
	tiles = {
		"stone_chest.png",
		"stone_chest.png",
		"stone_chest_side.png",
		"stone_chest_side.png",
		"stone_chest_side.png",
		"stone_chest_inside.png"
	},
	sounds = default.node_sound_stone_defaults(),
	sound_open = "default_chest_open",
	sound_close = "default_chest_close",
	groups = {cracky = 3, stone = 1},
})

minetest.register_craftitem("stone_chests:make_stone_chest", {
	groups = {not_in_creative_inventory = 1},
})

dungeon_loot.register({name = "stone_chests:make_stone_chest", chance = 1, types = {"normal"}})

minetest.register_abm({
	label = "Convert to stone chest",
	nodenames = {"default:chest"},
	interval = 1,
	chance = 1,
	action = function(pos, node)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		if not inv:contains_item("main", ItemStack("stone_chests:make_stone_chest")) then return end
		local contents = inv:get_list("main");
		local param2 = node.param2
		minetest.set_node(pos, {name = "stone_chests:stone_chest", param2 = param2})
		inv:set_list("main", contents)
		inv:remove_item("main",ItemStack("stone_chests:make_stone_chest"))
		return true

	end
})