local S = default.get_translator

minetest.register_node("unstable_caves:ustone", {
	description = S("Unstable Stone"),
	tiles = {"default_stone.png"},
	groups = {cracky = 3, stone = 1, falling_node = 1},
	drop = "default:cobble",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_ore({
	ore_type        = "blob",
	ore             = "unstable_caves:ustone",
	wherein         = {"default:stone"},
	clust_scarcity  = 15 * 15 * 15,
	clust_size      = 12,
	y_max           = -32,
	y_min           = -31000,
	noise_threshold = 0.0,
	noise_params    = {
		offset = 0.5,
		scale = 0.5,
		spread = {x = 7, y = 4, z = 7},
		seed = minetest.get_perlin(),
		octaves = 1,
		persist = 0.0
	},
})