stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
new = 0
local ptgwsc = {
    {"weightedstoragecube.png", "portalgun_presplat.png", "(blue)"},
    {"weightedstoragecube2.png", "portalgun_presplat2.png", "(orange)"},
    {"weightedstoragecube3.png", "portalgun_presplat3.png", "(yellow)"},
    {"weightedstoragecube4.png", "portalgun_presplat4.png", "(green)"},
    {"weightedcompanioncube.png", "portalgun_presplat.png", "(blue companion)"},
    {"weightedcompanioncube2.png", "portalgun_presplat2.png", "(orange companion)"},
    {"weightedcompanioncube3.png", "portalgun_presplat3.png", "(yellow companion)"},
    {"weightedcompanioncube4.png", "portalgun_presplat4.png", "(green companion)"}
}

for ii = 1, #ptgwsc, 1 do
    minetest.register_craftitem(
        "portalgun:wscube" .. ii,
        {
            description = "Weighted storage cube " .. ptgwsc[ii][3],
            inventory_image = minetest.inventorycube(ptgwsc[ii][1]),
            on_place = function(itemstack, user, pointed_thing)
                if pointed_thing.type == "node" then
                    new = 1
                    local m = minetest.add_entity(pointed_thing.above, "portalgun:wsc" .. ii)
                    m:set_acceleration({x = 0, y = -10, z = 0})
                    itemstack:take_item()
                end
                return itemstack
            end
        }
    )

    minetest.register_entity(
        "portalgun:wsc" .. ii,
        {
            hp_max = 100,
            physical = true,
            weight = 5,
            collisionbox = {-0.6, -0.6, -0.6, 0.6, 0.6, 0.6},
            visual = "cube",
            visual_size = {x = 1.1, y = 1.1},
            textures = {ptgwsc[ii][1], ptgwsc[ii][1], ptgwsc[ii][1], ptgwsc[ii][1], ptgwsc[ii][1], ptgwsc[ii][1]},
            initial_sprite_basepos = {x = 0, y = 0},
            is_visible = true,
            makes_footstep_sound = true,
            automatic_rotate = 0,
            portalgun = 2,
            wsc = ii,
            on_activate = function(self, staticdata)
                if new == 0 then
                    self.object:remove()
                    return self
                end
                new = 0
            end,
            on_step = function(self, dtime)
                self.timer = self.timer + dtime
                if self.timer < 1 then
                    return self
                end
                self.timer = 0
                self.object:set_acceleration({x = 0, y = -10, z = 0})
                self.timer2 = self.timer2 + 1
                if self.timer2 > 4 then
                    self.timer2 = 0
                    for i, ob in pairs(minetest.get_objects_inside_radius(self.object:get_pos(), 20)) do
                        if ob:is_player() then
                            return true
                        end
                    end
                    self.object:set_hp(0)
                end
            end,
            timer = 0,
            timer2 = 0
        }
    )
end --  of for #
