stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
local portaltarget_sig = {
    {1, "portalgun_blue.png"},
    {2, "portalgun_orange.png"}
}

for ii = 1, #portaltarget_sig, 1 do
    minetest.register_node(
        "portalgun:portaltarget_" .. portaltarget_sig[ii][1],
        {
            description = "Portal target " .. portaltarget_sig[ii][1],
            tiles = {"portalgun_testblock.png^" .. portaltarget_sig[ii][2]},
            groups = {mesecon = 2, cracky = 2},
            mesecons = {receptor = {state = "off"}},
            sounds = stone_sounds,
            is_ground_content = false,
            paramtype2 = "facedir",
            paramtype = "light",
            on_timer = function(pos, elapsed)
                for i, ob in pairs(minetest.get_objects_inside_radius(pos, 2)) do
                    if
                        ob:get_luaentity() and ob:get_luaentity().portalgun and
                            ob:get_luaentity().project == portaltarget_sig[ii][1]
                     then
                        mesecon.receptor_on(pos)

                        return true
                    end
                end
                mesecon.receptor_off(pos)
                return true
            end,
            on_construct = function(pos)
                if not mesecon then
                    return false
                end
                minetest.get_node_timer(pos):start(2)
            end
        }
    )
end
