stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}

minetest.register_node(
    "portalgun:cplps1",
    {
        description = "Close player portal",
        tiles = {"portalgun_gray.png"},
        groups = {mesecon = 2, snappy = 3, not_in_creative_inventory = 0},
        sounds = stone_sounds,
        is_ground_content = false,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    for i, ob in pairs(minetest.get_objects_inside_radius(pos, 6)) do
                        if ob and ob:is_player() then
                            portal_delete(ob:get_player_name(), 0)
                        end
                    end
                    minetest.swap_node(pos, {name = "portalgun:cplps2"})
                    minetest.after(
                        (2),
                        function(pos)
                            minetest.swap_node(pos, {name = "portalgun:cplps1"})
                        end,
                        pos
                    )

                    return false
                end
            }
        }
    }
)

minetest.register_node(
    "portalgun:cplps3",
    {
        description = "Close player portal when player is near",
        tiles = {"portalgun_gray.png"},
        groups = {snappy = 3, not_in_creative_inventory = 0},
        sounds = stone_sounds,
        is_ground_content = false,
        --every 2 seconds, check if player is near and close portal if so
        on_t = function(pos, elapsed)
            for i, ob in pairs(minetest.get_objects_inside_radius(pos, 4)) do
                if ob and ob:is_player() then
                    minetest.sound_play("portalgun_close", {pos = pos, gain = 1.0, max_hear_distance = 10})
                    portal_delete(ob:get_player_name(), 0)
                end
                --destroy all entities except players
                if ob and not ob:is_player() then
                    ob:remove()
                end
            end
            local timer = minetest.get_node_timer(pos)
            timer:start(2)
            return true
        end,
        after_place_node = function(pos, placer, itemstack, pointed_thing)
            local timer = minetest.get_node_timer(pos)
            timer:start(2)
        end
    }
)

minetest.register_node(
    "portalgun:cplps2",
    {
        description = "Close player portal",
        tiles = {"portalgun_gray.png^[colorize:#ffe85977"},
        groups = {mesecon = 2, snappy = 3, not_in_creative_inventory = 1},
        sounds = stone_sounds,
        is_ground_content = false,
        paramtype = "light",
        light_source = 4
    }
)
