stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
minetest.register_node(
    "portalgun:objdestroyer_1",
    {
        description = "Object destroyer (destroys on active)",
        tiles = {"portalgun_testblock.png^[colorize:#FF0000aa"},
        groups = {cracky = 2, mesecon = 1},
        sounds = stone_sounds,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    minetest.set_node(pos, {name = "portalgun:objdestroyer_2"})
                    for i, ob in pairs(minetest.get_objects_inside_radius(pos, 5)) do
                        if ob:get_luaentity() then
                            ob:set_hp(0)
                        end
                    end
                end
            }
        }
    }
)
minetest.register_node(
    "portalgun:objdestroyer_2",
    {
        description = "Obj destroyer",
        tiles = {"portalgun_testblock.png^[colorize:#FF0000cc"},
        groups = {cracky = 2, mesecon = 1, not_in_creative_inventory = 1},
        sunlight_propagates = true,
        drop = "portalgun:objdestroyer_1",
        paramtype = "light",
        light_source = 14,
        mesecons = {
            conductor = {
                state = mesecon.state.on,
                offstate = "portalgun:objdestroyer_1"
            }
        }
    }
)
