stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
new = 0
minetest.register_node(
    "portalgun:powerballspawner",
    {
        description = "Power ball spawner",
        tiles = {"steel.png", "steel.png", "steel.png", "steel.png", "steel.png", "portalgun_powerballspawner.png"},
        groups = {cracky = 2},
        sounds = glass_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        on_construct = function(pos)
            minetest.get_node_timer(pos):start(10)
        end,
        on_timer = function(pos, elapsed)
            local dir = minetest.get_node(pos).param2
            local v = {x = 0, y = 0, z = 0}
            if dir == 0 then
                v.z = -1
            elseif dir == 1 then
                v.x = -1
            elseif dir == 2 then
                v.z = 1
            elseif dir == 3 then
                v.x = 1
            elseif dir == 5 then
                v.y = -1
            elseif dir == 4 then
                v.y = 1
            else
                v.y = -1
            end
            local pv = {x = pos.x + v.x, y = pos.y + v.y, z = pos.z + v.z}
            new = 1
            local m = minetest.add_entity(pv, "portalgun:powerball")
            m:set_velocity({x = v.x * 4, y = v.y * 4, z = v.z * 4})
            return true
        end
    }
)
minetest.register_node(
    "portalgun:powerballspawner2",
    {
        description = "Power ball spawner (spawn on activate)",
        tiles = {
            "steel.png",
            "steel.png",
            "steel.png",
            "steel.png",
            "steel.png",
            "portalgun_powerballspawner.png^[colorize:#aaaa0055"
        },
        groups = {cracky = 2, mesecon = 1},
        sounds = glass_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        on_place = minetest.rotate_node,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    local dir = minetest.get_node(pos).param2
                    local v = {x = 0, y = 0, z = 0}
                    if dir == 0 then
                        v.z = -1
                    elseif dir == 1 then
                        v.x = -1
                    elseif dir == 2 then
                        v.z = 1
                    elseif dir == 3 then
                        v.x = 1
                    elseif dir == 8 then
                        v.y = -1
                    elseif dir == 4 then
                        v.y = 1
                    end
                    local pv = {x = pos.x + v.x, y = pos.y + v.y, z = pos.z + v.z}
                    new = 1
                    local m = minetest.add_entity(pv, "portalgun:powerball")
                    m:set_velocity({x = v.x * 4, y = v.y * 4, z = v.z * 4})
                end
            }
        }
    }
)
