local pgad_rules = {
    {x = 1, y = 0, z = 0},
    {x = -1, y = 0, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1}
}
stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}

minetest.register_node(
    "portalgun:delayer",
    {
        description = "Delayer (Punsh to change time)",
        tiles = {"portalgun_delayer.png", "portalgun_testblock.png"},
        groups = {dig_immediate = 2, mesecon = 1},
        sounds = stone_sounds,
        paramtype = "light",
        sunlight_propagates = true,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, -0.5, 0.5, -0.4, 0.5}
        },
        on_punch = function(pos, node, player, pointed_thing)
            if minetest.is_protected(pos, player:get_player_name()) == false then
                local meta = minetest.get_meta(pos)
                local time = meta:get_int("time")
                if time >= 10 then
                    time = 0
                end
                meta:set_int("time", time + 1)
                meta:set_string("infotext", "Delayer (" .. (time + 1) .. ")")
            end
        end,
        on_construct = function(pos)
            local meta = minetest.get_meta(pos)
            meta:set_int("time", 1)
            meta:set_string("infotext", "Delayer (1)")
            meta:set_int("case", 0)
        end,
        on_timer = function(pos, elapsed)
            local meta = minetest.get_meta(pos)
            if meta:get_int("case") == 2 then
                meta:set_int("case", 0)
                mesecon.receptor_off(pos)
            end
            if meta:get_int("case") == 1 then
                meta:set_int("case", 2)
                mesecon.receptor_on(pos)
                minetest.get_node_timer(pos):start(meta:get_int("time"))
            end
            return false
        end,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    local meta = minetest.get_meta(pos)
                    if meta:get_int("case") == 0 then
                        meta:set_int("case", 1)
                        minetest.get_node_timer(pos):start(meta:get_int("time"))
                    end
                end
            }
        }
    }
)
