stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
new = 0
local ptgwsc = {
    {"weightedstoragecube.png", "portalgun_presplat.png", "(blue)"},
    {"weightedstoragecube2.png", "portalgun_presplat2.png", "(orange)"},
    {"weightedstoragecube3.png", "portalgun_presplat3.png", "(yellow)"},
    {"weightedstoragecube4.png", "portalgun_presplat4.png", "(green)"},
    {"weightedcompanioncube.png", "portalgun_presplat.png", "(blue companion)"},
    {"weightedcompanioncube2.png", "portalgun_presplat2.png", "(orange companion)"},
    {"weightedcompanioncube3.png", "portalgun_presplat3.png", "(yellow companion)"},
    {"weightedcompanioncube4.png", "portalgun_presplat4.png", "(green companion)"}
}

for ii = 1, #ptgwsc, 1 do
    minetest.register_node(
        "portalgun:wscspawner2_" .. ii,
        {
            description = "Weighted storage cube spawner2 " .. ptgwsc[ii][3],
            tiles = {"steel.png", "steel.png", "steel.png", "steel.png", "steel.png", ptgwsc[ii][1]},
            groups = {cracky = 2, mesecon_receptor_off = 1, mesecon_effector_off = 1},
            sounds = glass_sounds,
            is_ground_content = false,
            paramtype2 = "facedir",
            mesecons = {
                receptor = {state = "off"},
                effector = {
                    action_on = function(pos, node)
                        local dir = minetest.get_node(pos).param2
                        local v = {x = 0, y = 0, z = 0}
                        if dir == 0 then
                            v.z = -1
                        elseif dir == 1 then
                            v.x = -1.2
                        elseif dir == 2 then
                            v.z = 1.2
                        elseif dir == 3 then
                            v.x = 1.2
                        elseif dir == 8 then
                            v.y = -1.2
                        elseif dir == 4 then
                            v.y = 1.2
                        end
                        local pv = {x = pos.x + v.x, y = pos.y + v.y, z = pos.z + v.z}
                        new = 1
                        local m = minetest.add_entity(pv, "portalgun:wsc" .. ii)
                        m:set_acceleration({x = 0, y = -10, z = 0})
                    end
                }
            }
        }
    )
    minetest.register_node(
        "portalgun:wscspawner" .. ii,
        {
            description = "Weighted storage cube spawner " .. ptgwsc[ii][3],
            tiles = {ptgwsc[ii][1]},
            groups = {cracky = 1, not_in_creative_inventory = 0},
            paramtype = "light",
            paramtype2 = "facedir",
            sunlight_propagates = true,
            light_source = 14,
            sounds = stone_sounds,
            drawtype = "nodebox",
            node_box = {
                type = "fixed",
                fixed = {
                    {-0.7, -0.5, -0.7, 0.7, -0.375, 0.7},
                    {0.7, -0.5, -0.1875, 0.9, -0.4375, 0.1875},
                    {-0.9, -0.5, -0.1875, -0.7, -0.4375, 0.1875},
                    {-0.1875, -0.5, -0.9, 0.1875, -0.4375, -0.7},
                    {-0.1875, -0.5, 0.7, 0.1875, -0.4375, 0.9}
                }
            },
            on_construct = function(pos)
                minetest.get_node_timer(pos):start(5)
            end,
            on_timer = function(pos, elapsed)
                for i, ob in pairs(minetest.get_objects_inside_radius(pos, 40)) do
                    if ob:get_luaentity() and ob:get_luaentity().wsc == ii then
                        return true
                    end
                end
                new = 1
                local m = minetest.add_entity(pos, "portalgun:wsc" .. ii)
                m:set_acceleration({x = 0, y = -10, z = 0})
                return true
            end
        }
    )
end --  of for #
