stone_sounds = {}
stone_sounds.footstep = {name="stone_walk", gain=1.0}
stone_sounds.dug = {name="stone_break", gain=1.0}
stone_sounds.place = {name="block_place", gain=1.0}
glass_sounds = {}
glass_sounds.footstep = {name="glass_walk", gain=1.0}
glass_sounds.dug = {name="glass_break", gain=1.0}
glass_sounds.place = {name="block_place", gain=1.0}
wood_sounds = {}
wood_sounds.footstep = {name="wood_walk", gain=1.0}
wood_sounds.dug = {name="wood_break", gain=1.0}
wood_sounds.place = {name="block_place", gain=1.0}
minetest.register_node("portalgun:secam_off", {
	description = "Security cam (off)" ,
	tiles = {"portalgun_scam.png"},
	drawtype = "nodebox",
	walkable=false,
	groups = {dig_immediate = 3},
	sounds = glass_sounds,
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	node_box = {type="fixed",
		fixed={	{-0.2, -0.5, -0.2, 0.2, -0.4, 0.2},
			{-0.1, -0.2, -0.1, 0.1, -0.4, 0.1}}
	},
	on_place = minetest.rotate_node,
	on_construct = function(pos)
		minetest.get_meta(pos):set_string("infotext","click to activate")
	end,
on_rightclick = function(pos, node, player, itemstack, pointed_thing)
	minetest.set_node(pos, {name ="portalgun:secam", param1 = node.param1, param2 = node.param2})
	minetest.get_node_timer(pos):start(1)
end,
})
minetest.register_node("portalgun:secam", {
	description = "Security cam",
	tiles = {"portalgun_scam.png"},
	drawtype = "nodebox",
	walkable=false,
	groups = {dig_immediate = 3,stone=1,not_in_creative_inventory=1},
	sounds = glass_sounds,
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	drop="portalgun:secam_off",
	node_box = {type="fixed",
		fixed={	{-0.2, -0.5, -0.2, 0.2, -0.4, 0.2},
			{-0.1, -0.2, -0.1, 0.1, -0.4, 0.1}}
	},
on_timer=function(pos, elapsed)
		for i, ob in pairs(minetest.get_objects_inside_radius(pos, 10)) do
			if ob:is_player() or (ob:get_luaentity() and ob:get_luaentity().itemstring==nil and ob:get_luaentity().portalgun==nil) then
				if portalgun_visiable(pos,ob) then
					local v=ob:get_pos()
					if not ob:get_luaentity() then v.y=v.y+1 end
					local s={x=(v.x-pos.x)*3,y=(v.y-pos.y)*3,z=(v.z-pos.z)*3}
					local m=minetest.add_entity(pos, "portalgun:bullet1")
					m:set_velocity(s)
					m:set_acceleration(s)
					minetest.sound_play("portalgun_bullet1", {pos=pos, gain = 1, max_hear_distance = 15,})
					minetest.after((math.random(1,9)*0.1), function(pos,s,v)
					local m=minetest.add_entity(pos, "portalgun:bullet1")
					m:set_velocity(s)
					m:set_acceleration(s)
					minetest.sound_play("portalgun_bullet1", {pos=pos, gain = 1, max_hear_distance = 15,})
					end, pos,s,v)
				end
			end
		end
		return true
	end,
})