--heal player every 4 ticks by 1 hp if isnt fully healed
i = 0
minetest.register_chatcommand("spawn",
{
	description = "Teleports a player to the spawn",
	func = function (name, param)
		local player = minetest.get_player_by_name(name)
		player:setpos({x = 0, y = 0, z = 0})
	end,

})
minetest.register_globalstep(function(dtime)
	if i>=4 then
		i=0
		for _,player in ipairs(minetest.get_connected_players()) do
			if player:get_hp()<20 and player:get_hp()>0 then
				player:set_hp(player:get_hp()+1)
			end
		end
	end
	i=i+1
end)
--on generating world set time_speed 0
minetest.register_on_generated(function(minp, maxp, seed)
	minetest.setting_set("time_speed", 0)
	--set time to 12000
	minetest.set_timeofday(0.5)
	--generate Toxic water below -100 else air
	for x = minp.x, maxp.x do
		for z = minp.z, maxp.z do
			for y = minp.y, maxp.y do
				local pos = {x=x,y=y,z=z}
				if y<-100 then
					minetest.set_node(pos,{name="portalgun:toxwater_1"})
				end
			end
		end
	end

end)
--disable digging and placing blocks for non admins
minetest.register_on_dignode(function(pos, oldnode, digger)
	if not digger:is_player() then return end
	local name = digger:get_player_name()
	if minetest.get_player_privs(name).server then return end
	minetest.chat_send_player(name,"You are not allowed to dig or place blocks!")
	minetest.set_node(pos, oldnode)
	--clear inventory
	digger:get_inventory():set_list("main", {})
end)
minetest.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
	if not placer:is_player() then return end
	local name = placer:get_player_name()
	if minetest.get_player_privs(name).server then return end
	minetest.chat_send_player(name,"You are not allowed to dig or place blocks!")
	minetest.set_node(pos, oldnode)
	--clear inventory
	local inv = placer:get_inventory()
	inv:set_list("main", {})
end)