stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
local ptgwsc = {
    {"weightedstoragecube.png", "portalgun_presplat.png", "(blue)"},
    {"weightedstoragecube2.png", "portalgun_presplat2.png", "(orange)"},
    {"weightedstoragecube3.png", "portalgun_presplat3.png", "(yellow)"},
    {"weightedstoragecube4.png", "portalgun_presplat4.png", "(green)"},
    {"weightedcompanioncube.png", "portalgun_presplat.png", "(blue companion)"},
    {"weightedcompanioncube2.png", "portalgun_presplat2.png", "(orange companion)"},
    {"weightedcompanioncube3.png", "portalgun_presplat3.png", "(yellow companion)"},
    {"weightedcompanioncube4.png", "portalgun_presplat4.png", "(green companion)"}
}

for ii = 1, #ptgwsc, 1 do
    minetest.register_node(
        "portalgun:plantform1_" .. ii,
        {
            description = "Pressure platform " .. ptgwsc[ii][3],
            tiles = {ptgwsc[ii][2], "cloud.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png"},
            groups = {mesecon = 2, cracky = 1, not_in_creative_inventory = 0},
            mesecons = {receptor = {state = "off"}},
            paramtype = "light",
            sunlight_propagates = true,
            sounds = stone_sounds,
            drawtype = "nodebox",
            node_box = {
                type = "fixed",
                fixed = {
                    {-0.7, -0.5, -0.7, 0.7, -0.375, 0.7},
                    {0.7, -0.5, -0.1875, 0.9, -0.4375, 0.1875},
                    {-0.9, -0.5, -0.1875, -0.7, -0.4375, 0.1875},
                    {-0.1875, -0.5, -0.9, 0.1875, -0.4375, -0.7},
                    {-0.1875, -0.5, 0.7, 0.1875, -0.4375, 0.9},
                    {-0.5, -0.5, -0.5, 0.5, -0.3125, 0.5}
                }
            },
            on_construct = function(pos)
                minetest.get_node_timer(pos):start(2)
            end,
            on_timer = function(pos, elapsed)
                if not mesecon then
                    return false
                end
                for i, ob in pairs(minetest.get_objects_inside_radius(pos, 1)) do
                    if ob:get_luaentity() and ob:get_luaentity().wsc == ii then
                        local node = minetest.get_node(pos)
                        mesecon.receptor_on(pos)
                        minetest.set_node(
                            pos,
                            {name = "portalgun:plantform2_" .. ii, param1 = node.param1, param2 = node.param2}
                        )
                    end
                    return true
                end
                return true
            end
        }
    )

    minetest.register_node(
        "portalgun:plantform2_" .. ii,
        {
            description = "Pressure platform",
            tiles = {ptgwsc[ii][2], "cloud.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png"},
            drop = "portalgun:plantform1_" .. ii,
            groups = {mesecon = 2, cracky = 1, not_in_creative_inventory = 1},
            mesecons = {receptor = {state = "on"}},
            paramtype = "light",
            sunlight_propagates = true,
            light_source = 14,
            sounds = stone_sounds,
            drawtype = "nodebox",
            node_box = {
                type = "fixed",
                fixed = {
                    {-0.7, -0.5, -0.7, 0.7, -0.375, 0.7},
                    {0.7, -0.5, -0.1875, 0.9, -0.4375, 0.1875},
                    {-0.9, -0.5, -0.1875, -0.7, -0.4375, 0.1875},
                    {-0.1875, -0.5, -0.9, 0.1875, -0.4375, -0.7},
                    {-0.1875, -0.5, 0.7, 0.1875, -0.4375, 0.9}
                }
            },
            on_construct = function(pos)
                minetest.get_node_timer(pos):start(2)
            end,
            on_timer = function(pos, elapsed)
                for i, ob in pairs(minetest.get_objects_inside_radius(pos, 1)) do
                    if ob:get_luaentity() and ob:get_luaentity().wsc == ii then
                        return true
                    end
                end
                mesecon.receptor_off(pos)
                local node = minetest.get_node(pos)
                minetest.set_node(
                    pos,
                    {name = "portalgun:plantform1_" .. ii, param1 = node.param1, param2 = node.param2}
                )
                return true
            end
        }
    )
end --  of for #

minetest.register_node(
    "portalgun:plantform_nu1",
    {
        description = "Pressure platform (player or cube)",
        tiles = {"portalgun_presplat5.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png"},
        groups = {mesecon = 2, cracky = 1, not_in_creative_inventory = 0},
        mesecons = {receptor = {state = "off"}},
        paramtype = "light",
        sunlight_propagates = true,
        sounds = stone_sounds,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.7, -0.5, -0.7, 0.7, -0.375, 0.7},
                {0.7, -0.5, -0.1875, 0.9, -0.4375, 0.1875},
                {-0.9, -0.5, -0.1875, -0.7, -0.4375, 0.1875},
                {-0.1875, -0.5, -0.9, 0.1875, -0.4375, -0.7},
                {-0.1875, -0.5, 0.7, 0.1875, -0.4375, 0.9},
                {-0.5, -0.5, -0.5, 0.5, -0.3125, 0.5}
            }
        },
        on_construct = function(pos)
            minetest.get_node_timer(pos):start(2)
        end,
        on_timer = function(pos, elapsed)
            if not mesecon then
                return false
            end
            for i, ob in pairs(minetest.get_objects_inside_radius(pos, 1)) do
                if ob:is_player() or (ob:get_luaentity() and ob:get_luaentity().wsc) then
                    local node = minetest.get_node(pos)
                    mesecon.receptor_on(pos)
                    minetest.set_node(
                        pos,
                        {name = "portalgun:plantform_nu2", param1 = node.param1, param2 = node.param2}
                    )
                end
                return true
            end
            return true
        end
    }
)
minetest.register_node(
    "portalgun:plantform_nu2",
    {
        description = "Pressure platform",
        tiles = {"portalgun_presplat5.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png", "cloud.png"},
        drop = "portalgun:plantform_nu1",
        groups = {mesecon = 2, cracky = 1, not_in_creative_inventory = 1},
        mesecons = {receptor = {state = "on"}},
        paramtype = "light",
        sunlight_propagates = true,
        light_source = 14,
        sounds = stone_sounds,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.7, -0.5, -0.7, 0.7, -0.375, 0.7},
                {0.7, -0.5, -0.1875, 0.9, -0.4375, 0.1875},
                {-0.9, -0.5, -0.1875, -0.7, -0.4375, 0.1875},
                {-0.1875, -0.5, -0.9, 0.1875, -0.4375, -0.7},
                {-0.1875, -0.5, 0.7, 0.1875, -0.4375, 0.9}
            }
        },
        on_construct = function(pos)
            minetest.get_node_timer(pos):start(2)
        end,
        on_timer = function(pos, elapsed)
            for i, ob in pairs(minetest.get_objects_inside_radius(pos, 1)) do
                if ob:is_player() or (ob:get_luaentity() and ob:get_luaentity().wsc) then
                    return true
                end
            end
            mesecon.receptor_off(pos)
            local node = minetest.get_node(pos)
            minetest.set_node(pos, {name = "portalgun:plantform_nu1", param1 = node.param1, param2 = node.param2})
            return true
        end
    }
)
minetest.register_node(
    "portalgun:planthole",
    {
        description = "Plathole (activate by any cube, 2 blocks under)",
        tiles = {"cloud.png"},
        groups = {mesecon = 2, cracky = 1},
        mesecons = {receptor = {state = "off"}},
        paramtype = "light",
        sunlight_propagates = true,
        sounds = stone_sounds,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-1.5, -0.5, -1.5, 0.5, -0.25, -1.3},
                {-1.5, -0.5, 0.3, 0.5, -0.25, 0.5},
                {0.3, -0.5, -1.5, 0.5, -0.25, 0.5},
                {-1.5, -0.5, -1.5, -1.3, -0.25, 0.5},
                {0.5, -0.5, -0.9, 0.7, -0.375, -0.0625},
                {-1.7, -0.5, -0.9, -1.5, -0.3125, -0.0625},
                {-0.9, -0.5, -1.7, -0.0625, -0.375, -1.5},
                {-1, -0.5, 0.5, -0.0625, -0.375, 0.7}
            }
        },
        on_construct = function(pos)
            minetest.get_node_timer(pos):start(5)
        end,
        on_timer = function(pos, elapsed)
            local pos2 = {x = pos.x, y = pos.y - 2, z = pos.z}
            for i, ob in pairs(minetest.get_objects_inside_radius(pos2, 1)) do
                if ob:get_luaentity() and ob:get_luaentity().wsc then
                    mesecon.receptor_on(pos)
                    return true
                end
            end
            mesecon.receptor_off(pos)
            return true
        end
    }
)