local pgad_rules = {
    {x = 1, y = 0, z = 0},
    {x = -1, y = 0, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1}
}
stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
minetest.register_node(
    "portalgun:dmgblock_1",
    {
        description = "Damage block (hurts when not active)",
        tiles = {"portalgun_powerwall.png"},
        groups = {cracky = 1, mesecon = 2},
        drawtype = "glasslike",
        paramtype = "light",
        use_texture_alpha = "blend",
        sunlight_propagates = true,
        sounds = stone_sounds,
        walkable = false,
        damage_per_second = 5,
        mesecons = {
            conductor = {
                state = mesecon.state.off,
                onstate = "portalgun:dmgblock_2",
                rules = pgad_rules
            }
        }
    }
)
minetest.register_node(
    "portalgun:dmgblock_2",
    {
        description = "Damage block",
        tiles = {"portalgun_gravity.png"},
        groups = {mesecon = 2, not_in_creative_inventory = 1},
        drawtype = "airlike",
        pointable = false,
        sunlight_propagates = true,
        drop = "portalgun:dmgblock_1",
        paramtype = "light",
        walkable = false,
        mesecons = {
            conductor = {
                state = mesecon.state.on,
                offstate = "portalgun:dmgblock_1",
                rules = pgad_rules
            }
        }
    }
)
