minetest.register_tool(
    "portalgun:pick",
    {
        --a pickaxe that can mine all blocks
        description = "Portalgun Pickaxe",
        inventory_image = "portalgun_pick.png",
        tool_capabilities = {
            full_punch_interval = 1.0,
            max_drop_level = 3,
            groupcaps = {
                unbreakable = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                fleshy = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                choppy = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                bendy = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                cracky = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                crumbly = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3},
                snappy = {times = {[1] = 1, [2] = 1, [3] = 1}, uses = 0, maxlevel = 3}
            },
            damage_groups = {fleshy = 1000}
        }
    }
)
minetest.register_tool(
    "portalgun:ed",
    {
        description = "Entity Destroyer",
        inventory_image = "portalgun_edestroyer.png",
        range = 15,
        on_use = function(itemstack, user, pointed_thing)
            local pos = user:get_pos()
            if pointed_thing.type == "node" then
                pos = pointed_thing.above
            end
            if pointed_thing.type == "object" then
                pos = pointed_thing.ref:get_pos()
            end
            local name = user:get_player_name()
            if minetest.check_player_privs(name, {kick = true}) == false then
                minetest.chat_send_player(name, "You need the kick privilege to use this tool!")
                return itemstack
            end
            for ii, ob in pairs(minetest.get_objects_inside_radius(pos, 7)) do
                if ob:get_luaentity() then
                    ob:set_hp(0)
                end
            end
            return itemstack
        end
    }
)
--register command for admins to build a testblock at the players position
minetest.register_chatcommand(
    "testblock",
    {
        params = "",
        description = "builds a testblock at the players position",
        privs = {server = true},
        func = function(name, param)
            local player = minetest.get_player_by_name(name)
            local pos = player:get_pos()
            minetest.set_node(pos, {name = "portalgun:testblock"})
        end
    }
)
