stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
local snuma = 1
for ii = 0, 9, 1 do
    if ii == 1 then
        snuma = 0
    end
    minetest.register_node(
        "portalgun:sign_numa" .. ii,
        {
            description = "Sign number (" .. ii .. ")",
            tiles = {"portalgun_snum" .. ii .. ".png"},
            drop = "portalgun:sign_numa1",
            drawtype = "nodebox",
            groups = {mesecon = 2, portalnuma = 1, dig_immediate = 3, not_in_creative_inventory = snuma},
            sounds = wood_sounds,
            is_ground_content = false,
            paramtype2 = "facedir",
            paramtype = "light",
            light_source = 3,
            node_box = {
                type = "fixed",
                fixed = {
                    {-0.5, -0.5, 0.4375, 0, 0.5, 0.5}
                }
            },
            after_place_node = function(pos, placer, itemstack)
                local param2 = minetest.get_node(pos).param2
                local pos2 = portalgun_param2(pos, param2)
                if minetest.get_node(pos2) and minetest.get_node(pos2).name == "air" then
                    minetest.set_node(pos2, {name = "portalgun:sign_numb1", param2 = param2})
                    minetest.swap_node(pos, {name = "portalgun:sign_numa0", param2 = minetest.get_node(pos).param2})
                end
            end,
            on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
                if not minetest.is_protected(pos, clicker:get_player_name()) then
                    local iin = ii + 1
                    if iin == 10 then
                        iin = 0
                    end
                    minetest.swap_node(
                        pos,
                        {name = "portalgun:sign_numa" .. iin, param2 = minetest.get_node(pos).param2}
                    )
                end
            end,
            on_punch = function(pos, node, player, pointed_thing)
                local param2 = minetest.get_node(pos).param2
                local pos2 = portalgun_param2(pos, param2)
                local node = minetest.get_node(pos2)
                if node and minetest.get_node_group(node.name, "portalnumb") > 0 then
                    minetest.set_node(pos2, {name = "air"})
                end
            end
        }
    )
    if snuma == 0 then
        snuma = 1
    end
    minetest.register_node(
        "portalgun:sign_numb" .. ii,
        {
            description = "Sign number",
            tiles = {"portalgun_snum" .. ii .. ".png"},
            drop = "portalgun:sign_numa1",
            drawtype = "nodebox",
            groups = {mesecon = 2, portalnumb = 1, dig_immediate = 3, not_in_creative_inventory = 1},
            sounds = wood_sounds,
            is_ground_content = false,
            paramtype2 = "facedir",
            paramtype = "light",
            light_source = 3,
            node_box = {
                type = "fixed",
                fixed = {
                    {-1, -0.5, 0.4375, -0.5, 0.5, 0.5}
                }
            },
            on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
                if not minetest.is_protected(pos, clicker:get_player_name()) then
                    local iin = ii + 1
                    if iin == 10 then
                        iin = 0
                    end
                    minetest.swap_node(
                        pos,
                        {name = "portalgun:sign_numb" .. iin, param2 = minetest.get_node(pos).param2}
                    )
                end
            end,
            on_punch = function(pos, node, player, pointed_thing)
                local param2 = minetest.get_node(pos).param2
                local pos2 = portalgun_param2(pos, param2, true)
                local node = minetest.get_node(pos2)
                if node and minetest.get_node_group(node.name, "portalnuma") > 0 then
                    minetest.set_node(pos2, {name = "air"})
                end
            end
        }
    )
end
minetest.register_node(
    "portalgun:sign1",
    {
        description = "Portal sign blue",
        tiles = {"portalgun_testblock.png^portalgun_sign1.png"},
        inventory_image = "portalgun_testblock.png^portalgun_sign1.png",
        drawtype = "nodebox",
        groups = {snappy = 3, not_in_creative_inventory = 0},
        sounds = wood_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        paramtype = "light",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.45, 0.5, 0.5, 0.5}
        }
    }
)

minetest.register_node(
    "portalgun:sign2",
    {
        description = "Portal sign orange",
        tiles = {"portalgun_testblock.png^portalgun_sign2.png"},
        inventory_image = "portalgun_testblock.png^portalgun_sign2.png",
        drawtype = "nodebox",
        groups = {snappy = 3, not_in_creative_inventory = 0},
        sounds = wood_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        paramtype = "light",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.45, 0.5, 0.5, 0.5}
        }
    }
)
minetest.register_node(
    "portalgun:sign_v",
    {
        description = "Sign V",
        tiles = {"portalgun_v.png"},
        inventory_image = "portalgun_v.png",
        drop = "portalgun:sign_x",
        drawtype = "nodebox",
        groups = {mesecon = 2, snappy = 3, not_in_creative_inventory = 1},
        sounds = wood_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        paramtype = "light",
        light_source = 5,
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.45, 0.5, 0.5, 0.5}
        },
        mesecons = {
            effector = {
                action_off = function(pos, node)
                    minetest.swap_node(pos, {name = "portalgun:sign_x", param2 = minetest.get_node(pos).param2})
                end
            }
        }
    }
)

minetest.register_node(
    "portalgun:sign_x",
    {
        description = "Sign X",
        tiles = {"portalgun_x.png"},
        inventory_image = "portalgun_x.png",
        drawtype = "nodebox",
        groups = {mesecon = 2, snappy = 3, not_in_creative_inventory = 0},
        sounds = wood_sounds,
        is_ground_content = false,
        paramtype2 = "facedir",
        paramtype = "light",
        light_source = 3,
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.45, 0.5, 0.5, 0.5}
        },
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    minetest.swap_node(pos, {name = "portalgun:sign_v", param2 = minetest.get_node(pos).param2})
                end
            }
        }
    }
)
