stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
local pgad_rules = {
    {x = 1, y = 0, z = 0},
    {x = -1, y = 0, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1}
}
minetest.register_node(
    "portalgun:testblock",
    {
        description = "Test block",
        tiles = {"portalgun_testblock.png"},
        groups = {cracky = 1},
        sounds = stone_sounds
    }
)

minetest.register_node(
    "portalgun:apb",
    {
        description = "Anti portal block",
        tiles = {"portalgun_testblock.png^[colorize:#ffffffaa"},
        groups = {cracky = 3, antiportal = 1},
        sounds = stone_sounds
    }
)

minetest.register_node(
    "portalgun:apg",
    {
        description = "Anti portal glass",
        drawtype = "glasslike",
        paramtype = "light",
        sunlight_propagates = true,
        tiles = {"glass.png^[colorize:#ffffffaa"},
        groups = {cracky = 1, antiportal = 1},
        sounds = glass_sounds
    }
)
minetest.register_node(
    "portalgun:hard_glass",
    {
        description = "Hard glass",
        drawtype = "glasslike",
        paramtype = "light",
        sunlight_propagates = true,
        tiles = {"glass.png^[colorize:#ddddddaa"},
        groups = {cracky = 1},
        sounds = glass_sounds
    }
)
minetest.register_node(
    "portalgun:testblocks",
    {
        description = "Trapblock",
        tiles = {"portalgun_testblock.png"},
        groups = {cracky = 1, mesecon = 2},
        sounds = stone_sounds,
        mesecons = {
            conductor = {
                state = mesecon.state.off,
                onstate = "portalgun:testblocks2",
                rules = pgad_rules
            }
        }
    }
)
minetest.register_node(
    "portalgun:testblocks2",
    {
        description = "Air block",
        tiles = {"portalgun_gravity.png"},
        groups = {mesecon = 2, not_in_creative_inventory = 1},
        drawtype = "airlike",
        pointable = false,
        sunlight_propagates = true,
        drop = "portalgun:testblocks",
        paramtype = "light",
        walkable = false,
        mesecons = {
            conductor = {
                state = mesecon.state.on,
                offstate = "portalgun:testblocks",
                rules = pgad_rules
            }
        }
    }
)
