minetest.register_node(
    "portalgun:toxwater_1",
    {
        description = "Toxic water",
        drawtype = "liquid",
        waving = 3,
        tiles = {
            {
                name = "portal_toxwater_anim.png",
                backface_culling = false,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
            {
                name = "portal_toxwater_anim.png",
                backface_culling = true,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
        },
        special_tiles = {
            {
                name = "portal_toxwater_anim.png",
                backface_culling = false,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
            {
                name = "portal_toxwater_anim.png",
                backface_culling = true,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
        },
        use_texture_alpha = "blend",
        paramtype = "light",
        walkable = false,
        pointable = false,
        diggable = false,
        buildable_to = true,
        is_ground_content = false,
        drop = "",
        drowning = 1,
        damage_per_second = 20,
        liquidtype = "source",
        liquid_alternative_flowing = "portalgun:toxwater_2",
        liquid_alternative_source = "portalgun:toxwater_1",
        liquid_viscosity = 2,
        liquid_renewable = false,
        liquid_range = 3,
        post_effect_color = {a = 200, r = 119, g = 70, b = 16},
        groups = {water = 3, liquid = 3}
    }
)

minetest.register_node(
    "portalgun:toxwater_2",
    {
        description = "Toxic water 2",
        drawtype = "flowingliquid",
        waving = 3,
        tiles = {
            {
                name = "portal_toxwater_anim.png",
                backface_culling = false,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
            {
                name = "portal_toxwater_anim.png",
                backface_culling = true,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
        },
        special_tiles = {
            {
                name = "portal_toxwater_anim.png",
                backface_culling = false,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
            {
                name = "portal_toxwater_anim.png",
                backface_culling = true,
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 8.0,
                },
            },
        },
        use_texture_alpha = "blend",
        paramtype = "light",
        paramtype2 = "flowingliquid",
        walkable = false,
        pointable = false,
        diggable = false,
        buildable_to = true,
        is_ground_content = false,
        drop = "",
        drowning = 1,
        damage_per_second = 4,
        liquidtype = "flowing",
        liquid_alternative_flowing = "portalgun:toxwater_2",
        liquid_alternative_source = "portalgun:toxwater_1",
        liquid_viscosity = 2,
        liquid_renewable = false,
        liquid_range = 3,
        post_effect_color = {a = 200, r = 119, g = 70, b = 16},
        groups = {water = 3, liquid = 3, not_in_creative_inventory = 1}
    }
)
