stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
checkpoints={}
minetest.register_node("portalgun:autocheckpoint", {
	description = "Checkpoint (teleports to here on death)",
	tiles = {"portalgun_checkpoint.png"},
	groups = {cracky = 3,not_in_creative_inventory=0},
	paramtype = "light",
	sunlight_propagates = true,
	light_source = 5,
	sounds = stone_sounds,
	drawtype="nodebox",
	node_box = {
	type="fixed",
	fixed={-0.5,-0.5,-0.5,0.5,-0.4,0.5}},
	on_construct = function(pos)
		minetest.get_meta(pos):set_string("infotext","Checkpoint")
		minetest.get_node_timer(pos):start(2)
	end,
	on_timer = function (pos, elapsed)
		for i, ob in pairs(minetest.get_objects_inside_radius(pos, 1.5)) do
			if ob:is_player() then
				local name=ob:get_player_name()
				if checkpoints[name]~=nil then
					local cp=checkpoints[name]
					if cp.x==pos.x and cp.y==pos.y and cp.z==pos.z then
						return true
					end
				end
				portal_delete(name,0)
				portalgun_portal[name]=nil
				checkpoints[name]=pos
				minetest.sound_play("portalgun_checkpoint", {pos=pos,max_hear_distance = 5, gain = 1})
				minetest.chat_send_player(name, "<Portalgun> You will spawn here next time you die")
			end
		end
		return true
	end,
})
minetest.register_on_respawnplayer(function(player)
	local name=player:get_player_name()
	minetest.after(1, function(name)
		if checkpoints[name]~=nil then
			player:move_to(checkpoints[name])
		end
	end, name)

end)
minetest.register_on_leaveplayer(function(player)
	local name=player:get_player_name()
	if checkpoints[name]~=nil then
		checkpoints[name]=nil
	end
end)