--Aliases

minetest.register_alias("mesecons_gamecompat:chest", "default:chest")
minetest.register_alias("mesecons_gamecompat:chest_locked", "default:chest_locked")
minetest.register_alias("mesecons_gamecompat:coalblock", "default:coalblock")
minetest.register_alias("mesecons_gamecompat:cobble", "default:cobble")
minetest.register_alias("mesecons_gamecompat:glass", "default:glass")
minetest.register_alias("mesecons_gamecompat:lava_source", "default:lava_source")
minetest.register_alias("mesecons_gamecompat:mese", "default:mese")
minetest.register_alias("mesecons_gamecompat:mese_crystal", "default:mese_crystal")
minetest.register_alias("mesecons_gamecompat:mese_crystal_fragment", "default:mese_crystal_fragment")
minetest.register_alias("mesecons_gamecompat:obsidian_glass", "default:obsidian_glass")
minetest.register_alias("mesecons_gamecompat:stone", "default:stone")
minetest.register_alias("mesecons_gamecompat:steel_ingot", "default:steel_ingot")
minetest.register_alias("mesecons_gamecompat:steelblock", "default:steelblock")
minetest.register_alias("mesecons_gamecompat:torch", "default:torch")

if minetest.get_modpath("dye") then
	for _, color in ipairs(mesecon.dye_colors) do
		minetest.register_alias("mesecons_gamecompat:dye_" .. color, "dye:" .. color)
	end
end

-- Sounds

mesecon.node_sound.default = default.node_sound_defaults()
mesecon.node_sound.glass = default.node_sound_glass_defaults()
mesecon.node_sound.leaves = default.node_sound_leaves_defaults()
mesecon.node_sound.stone = default.node_sound_stone_defaults()
mesecon.node_sound.wood = default.node_sound_wood_defaults()

if minetest.get_modpath("fire") then
	mesecon.sound_name.fire = "fire_fire"
end

if minetest.get_modpath("tnt") then
	mesecon.sound_name.explode = "tnt_explode"
end

-- MVPS stoppers

if minetest.get_modpath("mesecons_mvps") then
	-- All of the locked and internal nodes in Minetest Game
	for _, name in ipairs({
		"default:chest_locked",
		"default:chest_locked_open",
		"doors:door_steel_b_1", -- old style doors
		"doors:door_steel_b_2", --
		"doors:door_steel_t_1", --
		"doors:door_steel_t_2", --
		"doors:door_steel_a",   -- new style doors
		"doors:door_steel_b",   --
		"doors:door_steel_c",   --
		"doors:door_steel_d",   --
		"doors:hidden",
		"doors:trapdoor_steel",
		"doors:trapdoor_steel_open",
		"xpanes:door_steel_bar_a",
		"xpanes:door_steel_bar_b",
		"xpanes:door_steel_bar_c",
		"xpanes:door_steel_bar_d",
		"xpanes:trapdoor_steel_bar",
		"xpanes:trapdoor_steel_bar_open",
	}) do
		mesecon.register_mvps_stopper(name)
	end
end
