local pgad_rules = {
    {x = 1, y = 0, z = 0},
    {x = -1, y = 0, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1}
}
stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}

minetest.register_node(
    "portalgun:button",
    {
        description = "Button",
        tiles = {"portalgun_bu.png"},
        groups = {cracky = 3, mesecon = 1},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        selection_box = {type = "fixed", fixed = {-0.2, -0.5, -0.2, 0.2, 0.85, 0.2}},
        sounds = stone_sounds,
        mesecons = {receptor = {state = "off"}},
        on_rightclick = function(pos, node, clicker)
            mesecon.receptor_on(pos)
            minetest.get_node_timer(pos):start(2)
            minetest.sound_play("button_press", {pos = pos, max_hear_distance = 10, gain = 1})
        end,
        on_timer = function(pos, elapsed)
            mesecon.receptor_off(pos)
        end,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.25, -0.5, -0.25, 0.25, 0.7, 0.25},
                {-0.125, 0.5, -0.125, 0.125, 0.77, 0.125}
            }
        }
    }
)
