local pgad_rules = {
    {x = 1, y = 0, z = 0},
    {x = -1, y = 0, z = 0},
    {x = 0, y = 1, z = 0},
    {x = 0, y = -1, z = 0},
    {x = 0, y = 0, z = 1},
    {x = 0, y = 0, z = -1}
}
stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
minetest.register_node(
    "portalgun:powerdoor1_1",
    {
        description = "Power door",
        inventory_image = "portalgun_powerwall.png",
        wield_image = "portalgun_powerwall.png",
        groups = {mesecon = 1, unbreakable = 1, not_in_creative_inventory = 0},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        sounds = stone_sounds,
        drawtype = "nodebox",
        use_texture_alpha = "blend",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.4, 0.5, 0.5, 0.5}
        },
        tiles = {
            {
                name = "portalgun_powerwall1.png",
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 0.2
                }
            }
        },
        after_place_node = function(pos, placer, itemstack)
            local name = placer:get_player_name()
            minetest.get_meta(pos):set_string("owner", name)
            local p2 = minetest.get_node(pos)
            pos.y = pos.y + 1
            local n = minetest.get_node(pos)
            if n.name == "air" then
                minetest.set_node(pos, {name = "portalgun:powerdoor1_2", param2 = p2.param2})
                minetest.get_meta(pos):set_string("owner", name)
            end
        end,
        on_punch = function(pos, node, player, pointed_thing)
            local meta = minetest.get_meta(pos)
            if meta:get_string("owner") == player:get_player_name() then
                minetest.node_dig(pos, minetest.get_node(pos), player)
                pos.y = pos.y + 1
                local un = minetest.get_node(pos).name
                if un == "portalgun:powerdoor1_2" then
                    minetest.set_node(pos, {name = "air"})
                end
                pos.y = pos.y - 1
                return true
            end
        end,
        mesecons = {
            conductor = {
                state = mesecon.state.off,
                onstate = "portalgun:powerdoor2_1",
                rules = pgad_rules
            }
        }
    }
)

minetest.register_node(
    "portalgun:powerdoor1_2",
    {
        description = "Power door",
        inventory_image = "portalgun_powerwall.png",
        groups = {mesecon = 1, unbreakable = 1, not_in_creative_inventory = 1},
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        sounds = stone_sounds,
        drawtype = "nodebox",
        use_texture_alpha = "blend",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0.4, 0.5, 0.5, 0.5}
        },
        tiles = {
            {
                name = "portalgun_powerwall1.png",
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16,
                    aspect_h = 16,
                    length = 0.2
                }
            }
        },
        on_punch = function(pos, node, player, pointed_thing)
            local meta = minetest.get_meta(pos)
            if meta:get_string("owner") == player:get_player_name() then
                minetest.set_node(pos, {name = "air"})
                pos.y = pos.y - 1
                local un = minetest.get_node(pos).name
                if un == "portalgun:powerdoor1_1" then
                    minetest.node_dig(pos, minetest.get_node(pos), player)
                end
                pos.y = pos.y + 1
                return true
            end
        end,
        mesecons = {
            conductor = {
                state = mesecon.state.off,
                onstate = "portalgun:powerdoor2_2",
                rules = pgad_rules
            }
        }
    }
)

minetest.register_node(
    "portalgun:powerdoor2_1",
    {
        description = "Power door",
        inventory_image = "portalgun_powerwall.png",
        groups = {unbreakable = 1, mesecon = 1, not_in_creative_inventory = 1},
        paramtype = "light",
        sunlight_propagates = true,
        drawtype = "airlike",
        walkable = false,
        pointable = false,
        diggable = false,
        mesecons = {
            conductor = {
                state = mesecon.state.on,
                offstate = "portalgun:powerdoor1_1",
                rules = pgad_rules
            }
        }
    }
)

minetest.register_node(
    "portalgun:powerdoor2_2",
    {
        description = "Power door",
        inventory_image = "portalgun_powerwall.png",
        groups = {unbreakable = 1, mesecon = 1, not_in_creative_inventory = 1},
        paramtype = "light",
        sunlight_propagates = true,
        drawtype = "airlike",
        walkable = false,
        pointable = false,
        diggable = false,
        mesecons = {
            conductor = {
                state = mesecon.state.on,
                offstate = "portalgun:powerdoor1_2",
                rules = pgad_rules
            }
        }
    }
)
minetest.register_node(
    "portalgun:door_1",
    {
        description = "Mesecon Door",
        drop = "portalgun:door_1",
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.5, -0.5, -0.125, 0.5, 0.5, 0.125}
            }
        },
        tiles = {"portalgun_testblock.png"},
        groups = {mesecon = 1, cracky = 1, level = 2, not_in_creative_inventory = 0},
        sounds = stone_sounds,
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        is_ground_content = false,
        after_place_node = function(pos, placer, itemstack, pointed_thing)
            local p = {x = pos.x, y = pos.y + 1, z = pos.z}
            if minetest.registered_nodes[minetest.get_node(p).name].walkable then
                return false
            else
                minetest.set_node(p, {name = "portalgun:door_2", param2 = minetest.get_node(pos).param2})
            end
        end,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    local p = {x = pos.x, y = pos.y + 1, z = pos.z}
                    minetest.swap_node(p, {name = "portalgun:door_open_2", param2 = minetest.get_node(pos).param2})
                    minetest.swap_node(pos, {name = "portalgun:door_open_1", param2 = minetest.get_node(pos).param2})
                    minetest.sound_play("portalgun_door", {pos = pos, gain = 1, max_hear_distance = 5})
                end
            }
        },
        after_dig_node = function(pos, name, digger)
            minetest.set_node({x = pos.x, y = pos.y + 1, z = pos.z}, {name = "air"})
        end
    }
)

minetest.register_node(
    "portalgun:door_2",
    {
        description = "Door 2-1",
        drawtype = "nodebox",
        drop = "portalgun:door_1",
        node_box = {
            type = "fixed",
            fixed = {
                {-0.5, -0.5, -0.125, 0.5, 0.5, 0.125}
            }
        },
        tiles = {"portalgun_testblock.png"},
        groups = {mesecon = 1, cracky = 1, level = 2, not_in_creative_inventory = 1},
        sounds = wood_sounds,
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        is_ground_content = false,
        mesecons = {
            effector = {
                action_on = function(pos, node)
                    local p = {x = pos.x, y = pos.y - 1, z = pos.z}
                    minetest.swap_node(p, {name = "portalgun:door_open_1", param2 = minetest.get_node(pos).param2})
                    minetest.swap_node(pos, {name = "portalgun:door_open_2", param2 = minetest.get_node(pos).param2})
                    minetest.sound_play("portalgun_door", {pos = pos, gain = 1, max_hear_distance = 5})
                end
            }
        },
        after_dig_node = function(pos, name, digger)
            minetest.set_node({x = pos.x, y = pos.y - 1, z = pos.z}, {name = "air"})
        end
    }
)

minetest.register_node(
    "portalgun:door_open_1",
    {
        description = "Door (open) 2-o-1",
        drop = "portalgun:door_1",
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {
                {0.41, -0.5, -0.124, 1.41, 0.5, 0.125}
            }
        },
        tiles = {"portalgun_testblock.png"},
        groups = {mesecon = 1, cracky = 1, level = 2, not_in_creative_inventory = 1},
        sounds = wood_sounds,
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        is_ground_content = false,
        after_dig_node = function(pos, name, digger)
            minetest.set_node({x = pos.x, y = pos.y + 1, z = pos.z}, {name = "air"})
        end,
        mesecons = {
            effector = {
                action_off = function(pos, node)
                    local p = {x = pos.x, y = pos.y + 1, z = pos.z}
                    minetest.sound_play("portalgun_door", {pos = pos, gain = 1, max_hear_distance = 5})
                    minetest.swap_node(p, {name = "portalgun:door_2", param2 = minetest.get_node(pos).param2})
                    minetest.swap_node(pos, {name = "portalgun:door_1", param2 = minetest.get_node(pos).param2})
                end
            }
        }
    }
)

minetest.register_node(
    "portalgun:door_open_2",
    {
        description = "Door (open) 2-o-1",
        drawtype = "nodebox",
        drop = "portalgun:door_1",
        node_box = {
            type = "fixed",
            fixed = {
                {0.41, -0.5, -0.124, 1.41, 0.5, 0.125}
            }
        },
        tiles = {"portalgun_testblock.png"},
        groups = {mesecon = 1, cracky = 1, level = 2, not_in_creative_inventory = 1},
        sounds = wood_sounds,
        paramtype = "light",
        paramtype2 = "facedir",
        sunlight_propagates = true,
        is_ground_content = false,
        after_dig_node = function(pos, name, digger)
            minetest.set_node({x = pos.x, y = pos.y - 1, z = pos.z}, {name = "air"})
        end,
        mesecons = {
            effector = {
                action_off = function(pos, node)
                    local p = {x = pos.x, y = pos.y - 1, z = pos.z}
                    minetest.sound_play("portalgun_door", {pos = pos, gain = 1, max_hear_distance = 5})
                    minetest.swap_node(p, {name = "portalgun:door_1", param2 = minetest.get_node(pos).param2})
                    minetest.swap_node(pos, {name = "portalgun:door_2", param2 = minetest.get_node(pos).param2})
                end
            }
        }
    }
)
