stone_sounds = {}
stone_sounds.footstep = {name = "stone_walk", gain = 1.0}
stone_sounds.dug = {name = "stone_break", gain = 1.0}
stone_sounds.place = {name = "block_place", gain = 1.0}
glass_sounds = {}
glass_sounds.footstep = {name = "glass_walk", gain = 1.0}
glass_sounds.dug = {name = "glass_break", gain = 1.0}
glass_sounds.place = {name = "block_place", gain = 1.0}
wood_sounds = {}
wood_sounds.footstep = {name = "wood_walk", gain = 1.0}
wood_sounds.dug = {name = "wood_break", gain = 1.0}
wood_sounds.place = {name = "block_place", gain = 1.0}
new = 0
minetest.register_entity(
    "portalgun:powerball",
    {
        hp_max = 1000,
        physical = true,
        weight = 0,
        collisionbox = {-0.4, -0.4, -0.4, 0.4, 0.4, 0.4},
        visual = "sprite",
        visual_size = {x = 1.1, y = 1.1},
        textures = {"portalgun_powrball.png"},
        initial_sprite_basepos = {x = 0, y = 0},
        is_visible = true,
        makes_footstep_sound = false,
        automatic_rotate = 0,
        portalgun = 2,
        powerball = 1,
        on_activate = function(self, staticdata)
            if new == 0 then
                self.object:remove()
                return self
            end
            new = 0
            local pos = self.object:get_pos()
            self.sound = minetest.sound_play("portalgun_powerball", {pos = pos, max_hear_distance = 10, gain = 0.5})
            minetest.sound_play("portalgun_powerballbonce", {pos = pos, max_hear_distance = 10, gain = 1})
        end,
        on_step = function(self, dtime)
            self.timer = self.timer + dtime
            if self.timer < 0.2 then
                return self
            end
            self.timer = 0
            local pos = self.object:get_pos()
            for i, ob in pairs(minetest.get_objects_inside_radius(pos, 2)) do
                if
                    ob:is_player() or
                        (ob:get_luaentity() and ob:get_luaentity().portalgun ~= 1 and ob:get_luaentity().wsc == nil and
                            ob:get_luaentity().powerball ~= 1)
                 then
                    ob:set_hp(0)
                end
            end
            self.timer2 = self.timer2 + 1
            self.timer3 = self.timer3 + 1
            if self.timer3 >= 9 then
                self.timer3 = 0
                minetest.sound_stop(self.sound)
                self.sound = minetest.sound_play("portalgun_powerball", {pos = pos, max_hear_distance = 10, gain = 0.5})
            end
            if self.timer2 > 40 then
                minetest.sound_stop(self.sound)
                self.object:set_hp(0)
                return self
            end
            local v = self.object:get_velocity()
            local nextn = {x = pos.x + (v.x) / 3, y = pos.y + (v.y) / 3, z = pos.z + (v.z) / 3}
            local nname = minetest.get_node(nextn).name
            if minetest.registered_nodes[nname].walkable then
                if nname == "portalgun:powerballtarget" and mesecon then
                    mesecon.receptor_on(nextn)
                    minetest.get_node_timer(nextn):start(5)
                    self.object:remove()
                end
                self.object:set_velocity({x = v.x * -1, y = v.y * -1, z = v.z * -1})
                minetest.sound_play("portalgun_powerballbonce", {pos = pos, max_hear_distance = 10, gain = 1})
            end
        end,
        timer = 0,
        timer2 = 0,
        timer3 = 0,
        sound = {}
    }
)
