-- Please leave a review on Content Data Base
-- Blocky_Player



--Overrides conifeous litter to drop bones

minetest.override_item("default:dirt_with_coniferous_litter", {
	drop = {
		max_item = 1,
		items = {
			{
				items = {"more_stones:bone"},
				rarity = 15,
			},
			{
				items = {"default:dirt_with_coniferous_litter"},
			}
		}
	},
})

--Item Registration

minetest.register_craftitem("more_stones:chisel", {
	description = "Chisel", --may have a different functionality later
	inventory_image = "chisel.png",
})

minetest.register_craftitem("more_stones:shell", {
	description = "Shells",
	inventory_image = "shell.png",
})

minetest.register_craftitem("more_stones:marble_rock", {
	description = "Marble Rock",
	inventory_image = "marble_rock.png"
})

minetest.register_craftitem("more_stones:bone", {
	description = "Bone",
	inventory_image = "bone.png",
})

minetest.register_craftitem("more_stones:volcanic_ash", {
	description = "Volcanic Ash",
	inventory_image = "ash.png",
})

--Educational Node Registration

minetest.register_node("more_stones:sedimentary_rock", {
	description = ("Sedimentary Rock"),
	tiles = {"sedimentary_rock.png"},
	groups = {cracky = 2, crumbly = 1, not_in_creative_inventory = 1}, --blocks without a recipe are for learning purposes. Use as examples of what certain types of rocks look like
	sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("more_stones:igneous_rock", {
	description = ("Igneous Rock"),
	tiles = {"igneous_rock.png"},
	groups = {cracky = 3, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:metamorphic_rock", {
	description = ("Metamorphic Rock"),
	tiles = {"metamorphic_rock.png"},
	groups = {cracky = 3, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

--Survival Node Registration

minetest.register_node("more_stones:dense_stone", {
	description = ("Dense Stone"), 
	tiles = {"dense_stone.png"},
	drop = {"default:stone"},
	groups = {cracky = 3, stone = 1, level = 2}, 
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:marble", {
	description = ("Marble"),
	tiles = {"marble.png"},
	drop = {"more_stones:marble_rock"},
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:polished_marble", {
	description = ("Polished Marble"),
	tiles = {"polished_marble.png"},
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:coquina", {
	description = ("Coquina"),
	tiles = {"coquina.png"},
	groups = {cracky = 2, crumbly = 3},
	sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("more_stones:limestone", {
	description = ("Limestone"),
	tiles = {"limestone.png"},
	groups = {cracky = 1, stone = 1},
	sounds = default.node_sound_dirt_defaults(),
})

minetest.register_node("more_stones:stone_pillar", {
	description = ("Stone Pillar"),
	paramtype2 = "facedir",
	tiles = {"stone_pillar.png"},
	groups = {cracky = 3, stone = 1},
	sounds = default.node_sound_stone_defaults(),
	
	on_place = minetest.rotate_node
})

minetest.register_node("more_stones:marble_pillar", {
	description = "Marble Pillar",
	paramtype2 = "facedir",
	tiles = {"marble_pillar.png"},
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
	
	on_place = minetest.rotate_node
})

minetest.register_node("more_stones:mud_pillar", {
	description = "Mud Pillar",
	paramtype2 = "facedir",
	tiles = {"mud_pillar.png"},
	groups = {cracky = 3, crubmly = 2},
	sounds = default.node_sound_stone_defaults(),
	
	on_place = minetest.rotate_node
})

minetest.register_node("more_stones:forged_stone", {
	description = "Forged Stone",
	tiles = {"forged_stone.png"},
	groups = {cracky = 5},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:scoria", {
	description = "Scoria",
	tiles = {"scoria.png"},
	groups = {cracky = 4},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:polished_scoria", {
	description = "Polished Scoria",
	tiles = {"polished_scoria.png"},
	groups = {cracky = 3.5},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_node("more_stones:red_scoria", {
	description = "Polished Red Scoria",
	tiles = {"polished_scoria_red.png"},
	groups = {cracky = 3.5},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:purple_scoria", {
	description = "Polished Purple Scoria",
	tiles = {"scoria_purple.png"},
	groups = {cracky = 3.5},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:magma", {
	description = "Magma",
	tiles = {"magma.png"},
	groups = {cracky = 3.75, igniter = 1},
	damage_per_second = 2 * 2,
	light_source = default.LIGHT_MAX,
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("more_stones:tuff", {
	description = "Tuff",
	tiles = {"tuff.png"},
	groups = {cracky = 2, crumbly = 3},
	sounds = default.node_sound_gravel_defaults(),
})

minetest.register_node("more_stones:tuff_bricks", {
	description = "Tuff Bricks",
	tiles = {"tuff_brick.png"},
	groups = {cracky = 2},
	sounds = default.node_sound_stone_defaults(),
})

--note the missing node for 'marble_ore'. Texture may be re-used later

--Register Crafting

minetest.register_craft({
	output = "more_stones:tuff_bricks 6",
	recipe = {
		{"more_stones:tuff", "more_stones:tuff"},
		{"default:clay_lump", "default:sand", "bucket:bucket_water"},
	}
})

minetest.register_craft({
	output = "more_stones:volcanic_ash 6",
	recipe = {
		{"default:coal_lump", "default:stone"},
		{"default:stone", "default:stone"},
	}
})

minetest.register_craft({
	output = "more_stones:polished_scoria 4",
	recipe = {
		{"more_stones:scoria", "more_stones:scoria", "bucket:bucket_water"},
		{"more_stones:scoria", "more_stones:scoria"},
	}
})

minetest.register_craft({
	output = "more_stones:red_scoria 4",
	recipe = {
		{"more_stones:scoria", "more_stones:scoria", "bucket:bucket_water"},
		{"more_stones:scoria", "more_stones:scoria", "more_stones:magma"},
	}
})

minetest.register_craft({
	output = "more_stones:purple_scoria 4",
	recipe = {
		{"more_stones:scoria", "more_stones:red", "bucket:bucket_water"},
		{"more_stones:red", "more_stones:scoria", "more_stones:magma"},
	}
})

minetest.register_craft({
	output = "more_stones:dense_stone 4",
	recipe = {
		{"default:stone_block", "default:stone"},
		{"default:stone", "default:stone_block"}, 
	}
})

minetest.register_craft({
	output = "more_stones:marble",
	recipe = {
		{"more_stones:marble_rock", "more_stones:marble_rock"},
		{"more_stones:marble_rock", "more_stones:marble_rock"},
	}
})

minetest.register_craft({
	output = "more_stones:polished_marble",
	recipe = {
		{"more_stones:marble", "more_stones:marble", "bucket:bucket_water"},
		{"more_stones:marble", "more_stones:marble"},
	}
})

minetest.register_craft({
	output = "more_stones:coquina",
	type = "shapeless",
	recipe = {
		"more_stones:shell",
		"more_stones:shell",
		"more_stones:shell",
		"more_stones:shell",
	},
})

minetest.register_craft({
	output = "more_stones:stone_pillar",
	recipe = {
		"more_stones:chisel",
		"default:stone",
	},
})

minetest.register_craft({
	output = "more_stones:marble_pillar",
	recipe = {
		"more_stones:chisel",
		"more_stones:marble",
	},
})

minetest.register_craft({
	output = "more_stones:mud_pillar",
	recipe = {
		"more_stones:chisel",
		"mud:mud",
	},
})

minetest.register_craft({
	output = "more_stones:chisel",
	recipe = {
		"more_stones:forged_stone",
		"group:stick",
	},
})

minetest.register_craft({
	output = "more_stones:stone_pillar",
	recipe = {
		"screwdriver:screwdriver",
		"default:stone",
	},
})

minetest.register_craft({
	output = "more_stones:marble_pillar",
	recipe = {
		"screwdriver:screwdriver",
		"more_stones:marble",
	},
})

minetest.register_craft({
	output = "more_stones:mud_pillar",
	recipe = {
		"screwdriver:screwdriver",
		"mud:mud",
	},
})

minetest.register_craft({
	output = "more_stones:forged_stone",
	recipe = {
		{"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
		{"default:steel_ingot", "group:stone", "default:steel_ingot"},
		{"default:steel_ingot", "default:steel_ingot", "default:steel_ingot"},
	},
})

minetest.register_craft({
	output = "more_stones:lime_stone",
	recipe = {
		{"bucket:bucket_water", "more_stones:shell"},
		{"more_stones:shell", "bucket:bucket_water"},
	},
})

--Mapgen

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "more_stones:limestone",
		wherein         = {"default:stone"},
		clust_scarcity  = 14 * 14 * 14,
		clust_size      = 8,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})

		minetest.register_ore({
		ore_type        = "blob",
		ore             = "more_stones:magma",
		wherein         = {"default:stone"},
		clust_scarcity  = 14 * 14 * 14,
		clust_size      = 8,
		y_max           = -20000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})

		minetest.register_ore({
		ore_type        = "blob",
		ore             = "more_stones:tuff",
		wherein         = {"default:stone"},
		clust_scarcity  = 12 * 12 * 12,
		clust_size      = 8,
		y_max           = 20000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 766,
			octaves = 1,
			persist = 0.0
		},
	})