local player_data = {}

local UPDATE_INTERVAL = 0.1 -- Sekunden

-- Optimierte HUD-Positionen mit Abstand zu Hotbar und Bildschirmrand
local positions = {
    oben_links   = {x=0.05, y=0.05},
    oben_mitte   = {x=0.5, y=0.05},
    oben_rechts  = {x=0.95, y=0.05},
    mitte_links  = {x=0.05, y=0.5},
    mitte_mitte  = {x=0.5, y=0.5},
    mitte_rechts = {x=0.95, y=0.5},
    unten_links  = {x=0.05, y=0.85},
    unten_mitte  = {x=0.5, y=0.85}, -- direkt über Hotbar/Hungerleiste
    unten_rechts = {x=0.95, y=0.85},
}

local function get_color(kmh)
    if kmh < 10 then return 0x00FF00
    elseif kmh < 25 then return 0xFFFF00
    else return 0xFF0000 end
end

local function distance(pos1, pos2)
    local dx = pos2.x - pos1.x
    local dy = pos2.y - pos1.y
    local dz = pos2.z - pos1.z
    return math.sqrt(dx*dx + dy*dy + dz*dz)
end

local DEFAULT_POS = "unten_mitte"

minetest.register_globalstep(function(dtime)
    local now = minetest.get_us_time() / 1e6 -- aktuelle Zeit in Sekunden

    for _, player in ipairs(minetest.get_connected_players()) do
        local name = player:get_player_name()
        local pos = player:get_pos()

        if not player_data[name] then
            player_data[name] = {
                last_pos = pos,
                hud_id = nil,
                max_speed = 0,
                hud_pos = DEFAULT_POS,
                last_update = now
            }
        end

        local pdata = player_data[name]
        local dt = now - pdata.last_update

        if dt >= UPDATE_INTERVAL then
            local dx = pos.x - pdata.last_pos.x
            local dy = pos.y - pdata.last_pos.y
            local dz = pos.z - pdata.last_pos.z

            local horizontal = math.sqrt(dx*dx + dz*dz) / dt
            local vertical = dy / dt
            local speed_ms = math.sqrt(dx*dx + dy*dy + dz*dz) / dt
            local speed_kmh = speed_ms * 3.6
            local horiz_kmh = horizontal * 3.6
            local vert_kmh = vertical * 3.6

            if speed_kmh > pdata.max_speed then
                pdata.max_speed = speed_kmh
            end

            local color = get_color(speed_kmh)

            local text = string.format(
                "Horiz: %.2f m/s (%.1f km/h)\nVert: %.2f m/s (%.1f km/h)\nGesamt: %.2f m/s (%.1f km/h)\nMax: %.1f km/h",
                horizontal, horiz_kmh,
                vertical, vert_kmh,
                speed_ms, speed_kmh,
                pdata.max_speed
            )

            local hud_position = positions[pdata.hud_pos] or positions[DEFAULT_POS]

            if not pdata.hud_id then
                pdata.hud_id = player:hud_add({
                    hud_elem_type = "text",
                    position = hud_position,
                    offset = {x=0, y=0},
                    text = text,
                    alignment = {x=0.5, y=0},
                    scale = {x=100, y=100},
                    number = color
                })
            else
                player:hud_change(pdata.hud_id, "text", text)
                player:hud_change(pdata.hud_id, "number", color)
                player:hud_change(pdata.hud_id, "position", hud_position)
            end

            pdata.last_pos = pos
            pdata.last_update = now
        end
    end
end)

-- Chatbefehl zur HUD-Positionsänderung
minetest.register_chatcommand("speedhud", {
    params = "pos <position>",
    description = "Ändert die HUD-Position. Positionen: oben_links, oben_mitte, oben_rechts, mitte_links, mitte_mitte, mitte_rechts, unten_links, unten_mitte, unten_rechts",
    func = function(name, param)
        local pdata = player_data[name]
        if not pdata then return false, "Spielerdaten nicht gefunden!" end
        local args = {}
        for word in param:gmatch("%S+") do table.insert(args, word) end
        if args[1] == "pos" and args[2] and positions[args[2]] then
            pdata.hud_pos = args[2]
            return true, "HUD-Position auf "..args[2].." gesetzt."
        else
            return false, "Ungültige Position! Möglich: oben_links, oben_mitte, oben_rechts, mitte_links, mitte_mitte, mitte_rechts, unten_links, unten_mitte, unten_rechts"
        end
    end
})
