# Content.DB Upload-Checkliste / Content.DB Upload Checklist

Diese Checkliste hilft dir, jede Mod für die Minetest Content Database (Content.DB) vorzubereiten und hochzuladen. / This checklist helps you prepare each mod for the Minetest Content Database (Content.DB) and upload it.

---

## Deutsch / German

### 1. Mod-Ordner und Dateien
- [ ] Mod-Ordnername eindeutig, ohne Leerzeichen oder Sonderzeichen (z. B. `lokator_towncraft`)
- [ ] `init.lua` vorhanden
- [ ] `depends.txt` vorhanden, falls andere Mods benötigt werden
- [ ] `README.md` vorhanden, mindestens in Englisch
- [ ] `LICENSE` vorhanden, freie Open-Source-Lizenz (MIT, GPL, CC0)
- [ ] Ressourcenordner vorhanden (`textures/`, `models/`, `sounds/`), falls notwendig
- [ ] `locale/`-Ordner mit `.po`-Dateien für Übersetzungen vorhanden

### 2. mod.conf / modpack.conf
- [ ] `name` korrekt und einzigartig
- [ ] `description` klar und aussagekräftig
- [ ] `author` korrekt angegeben
- [ ] `license` angegeben und mit LICENSE-Datei konsistent
- [ ] `depends` korrekt angegeben (falls notwendig)
- [ ] `version` angegeben (z. B. 1.0.0) und bei Updates erhöht

### 3. README.md
- [ ] Englische Version vorhanden
- [ ] Optional: Deutsche Version oder weitere Sprachen
- [ ] Installation beschrieben
- [ ] Features beschrieben
- [ ] Screenshots eingebunden und funktionsfähig
- [ ] Lizenzhinweis enthalten

### 4. Übersetzungen
- [ ] Alle Texte über `minetest.get_translator("meine_mod")` eingebunden
- [ ] `.po`-Dateien für alle unterstützten Sprachen vorhanden
- [ ] Englische Übersetzung (`en.po`) vorhanden
- [ ] Änderungen getestet, Texte korrekt im Spiel angezeigt

### 5. Testen
- [ ] Singleplayer-Test erfolgreich
- [ ] Keine Fehler oder Abstürze
- [ ] Alle Abhängigkeiten erfüllt
- [ ] Performance in Ordnung

### 6. Screenshots
- [ ] Screenshots vorhanden und aussagekräftig
- [ ] Dateigröße angemessen (1–2 MB pro Bild)
- [ ] Pfade in README.md korrekt
- [ ] Optional: externe Screenshots nur bei Bedarf

### 7. Einreichung auf Content.DB
- [ ] Benutzerkonto erstellt und eingeloggt
- [ ] Alle Felder im Upload-Formular ausgefüllt: Name, Kurzbeschreibung, Kategorie, Lizenz, Version, Download-Link (Repository oder ZIP)
- [ ] Screenshots hochgeladen
- [ ] Community-Richtlinien beachtet (keine schädlichen Inhalte, keine nicht-freien Assets)

### 8. Updates
- [ ] Versionsnummer in `mod.conf` erhöht
- [ ] Changelog gepflegt
- [ ] Neue Screenshots hochgeladen (falls Änderungen sichtbar)

---

## English / Englisch

### 1. Mod folder and files
- [ ] Mod folder name unique, no spaces or special characters (e.g., `lokator_towncraft`)
- [ ] `init.lua` present
- [ ] `depends.txt` present if other mods are required
- [ ] `README.md` present, at least in English
- [ ] `LICENSE` present, free open-source license (MIT, GPL, CC0)
- [ ] Resource folders present (`textures/`, `models/`, `sounds/`), if needed
- [ ] `locale/` folder with `.po` files for translations present

### 2. mod.conf / modpack.conf
- [ ] `name` correct and unique
- [ ] `description` clear and concise
- [ ] `author` correct
- [ ] `license` specified and consistent with LICENSE file
- [ ] `depends` correct (if necessary)
- [ ] `version` specified (e.g., 1.0.0) and increased with updates

### 3. README.md
- [ ] English version present
- [ ] Optional: German or other languages
- [ ] Installation described
- [ ] Features described
- [ ] Screenshots embedded and working
- [ ] License notice included

### 4. Translations
- [ ] All text strings included via `minetest.get_translator("my_mod")`
- [ ] `.po` files present for all supported languages
- [ ] English translation (`en.po`) present
- [ ] Changes tested in-game, texts display correctly

### 5. Testing
- [ ] Singleplayer test successful
- [ ] No errors or crashes
- [ ] All dependencies satisfied
- [ ] Performance acceptable

### 6. Screenshots
- [ ] Screenshots present and meaningful
- [ ] File size reasonable (1–2 MB per image)
- [ ] Paths in README.md correct
- [ ] Optional: external screenshots only if necessary

### 7. Submission to Content.DB
- [ ] Account created and logged in
- [ ] All fields in the upload form completed: Name, Description, Category, License, Version, Download link (repository or ZIP)
- [ ] Screenshots uploaded
- [ ] Community guidelines followed (no harmful content, no non-free assets)

### 8. Updates
- [ ] Version number in `mod.conf` increased
- [ ] Changelog maintained
- [ ] New screenshots uploaded (if changes visible)

---

> Hinweis / Note: Diese Checkliste kann als Template für alle Mods verwendet werden, um sicherzustellen, dass jede Mod vollständig vorbereitet ist, bevor sie auf die Minetest Content.DB hochgeladen wird. / This checklist can be used as a template for all mods to ensure each mod is fully prepared before uploading to the Minetest Content.DB.
